/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class AvoidStaticImportCheck
extends Check {
    public static final String MSG_KEY = "import.avoidStatic";
    private String[] excludes = new String[0];

    @Override
    public int[] getDefaultTokens() {
        return new int[]{152};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{152};
    }

    public void setExcludes(String ... excludes) {
        this.excludes = (String[])excludes.clone();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST startingDot = ast.getFirstChild().getNextSibling();
        FullIdent name = FullIdent.createFullIdent(startingDot);
        if (!this.isExempt(name.getText())) {
            this.log(startingDot.getLineNo(), MSG_KEY, name.getText());
        }
    }

    private boolean isExempt(String classOrStaticMember) {
        for (String exclude : this.excludes) {
            String member;
            String excludeMinusDotStar;
            if (classOrStaticMember.equals(exclude)) {
                return true;
            }
            if (!exclude.endsWith(".*") || !classOrStaticMember.startsWith(excludeMinusDotStar = exclude.substring(0, exclude.length() - 2)) || classOrStaticMember.equals(excludeMinusDotStar) || (member = classOrStaticMember.substring(excludeMinusDotStar.length() + 1)).indexOf(46) != -1) continue;
            return true;
        }
        return false;
    }
}

