/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.ASTEnumeration;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableDeclarationUsageDistanceCheck
extends Check {
    public static final String MSG_KEY = "variable.declaration.usage.distance";
    public static final String MSG_KEY_EXT = "variable.declaration.usage.distance.extend";
    private static final int DEFAULT_DISTANCE = 3;
    private int allowedDistance = 3;
    private Pattern ignoreVariablePattern = Pattern.compile("");
    private boolean validateBetweenScopes;
    private boolean ignoreFinal = true;

    public void setAllowedDistance(int allowedDistance) {
        this.allowedDistance = allowedDistance;
    }

    public void setIgnoreVariablePattern(String ignorePattern) {
        this.ignoreVariablePattern = Utils.createPattern(ignorePattern);
    }

    public void setValidateBetweenScopes(boolean validateBetweenScopes) {
        this.validateBetweenScopes = validateBetweenScopes;
    }

    public void setIgnoreFinal(boolean ignoreFinal) {
        this.ignoreFinal = ignoreFinal;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST variable;
        int parentType = ast.getParent().getType();
        DetailAST modifiers = ast.getFirstChild();
        if (!(this.ignoreFinal && modifiers.branchContains(39) || parentType == 6 || this.isVariableMatchesIgnorePattern((variable = ast.findFirstToken(58)).getText()))) {
            DetailAST semicolonAst = ast.getNextSibling();
            Map.Entry<DetailAST, Integer> entry = null;
            entry = this.validateBetweenScopes ? VariableDeclarationUsageDistanceCheck.calculateDistanceBetweenScopes(semicolonAst, variable) : VariableDeclarationUsageDistanceCheck.calculateDistanceInSingleScope(semicolonAst, variable);
            DetailAST variableUsageAst = entry.getKey();
            int dist = entry.getValue();
            if (dist > this.allowedDistance && !VariableDeclarationUsageDistanceCheck.isInitializationSequence(variableUsageAst, variable.getText())) {
                if (this.ignoreFinal) {
                    this.log(variable.getLineNo(), MSG_KEY_EXT, variable.getText(), dist, this.allowedDistance);
                } else {
                    this.log(variable.getLineNo(), MSG_KEY, variable.getText(), dist, this.allowedDistance);
                }
            }
        }
    }

    private static String getInstanceName(DetailAST methodCallAst) {
        String methodCallName = FullIdent.createFullIdentBelow(methodCallAst).getText();
        int lastDotIndex = methodCallName.lastIndexOf(46);
        String instanceName = "";
        if (lastDotIndex != -1) {
            instanceName = methodCallName.substring(0, lastDotIndex);
        }
        return instanceName;
    }

    private static boolean isInitializationSequence(DetailAST variableUsageAst, String variableName) {
        boolean result = true;
        boolean isUsedVariableDeclarationFound = false;
        String initInstanceName = "";
        block5: for (DetailAST currentSiblingAst = variableUsageAst; result && !isUsedVariableDeclarationFound && currentSiblingAst != null; currentSiblingAst = currentSiblingAst.getPreviousSibling()) {
            switch (currentSiblingAst.getType()) {
                case 28: {
                    DetailAST methodCallAst = currentSiblingAst.getFirstChild();
                    if (methodCallAst != null && methodCallAst.getType() == 27) {
                        String instanceName = VariableDeclarationUsageDistanceCheck.getInstanceName(methodCallAst);
                        if (instanceName.isEmpty()) {
                            result = false;
                            continue block5;
                        }
                        if (instanceName.equals(initInstanceName)) continue block5;
                        if (!initInstanceName.isEmpty()) {
                            result = false;
                            continue block5;
                        }
                        initInstanceName = instanceName;
                        continue block5;
                    }
                    result = false;
                    continue block5;
                }
                case 10: {
                    String currentVariableName = currentSiblingAst.findFirstToken(58).getText();
                    isUsedVariableDeclarationFound = variableName.equals(currentVariableName);
                    continue block5;
                }
                case 45: {
                    continue block5;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    private static Map.Entry<DetailAST, Integer> calculateDistanceInSingleScope(DetailAST semicolonAst, DetailAST variableIdentAst) {
        int dist = 0;
        boolean firstUsageFound = false;
        DetailAST variableUsageAst = null;
        for (DetailAST currentAst = semicolonAst; !firstUsageFound && currentAst != null && currentAst.getType() != 73; currentAst = currentAst.getNextSibling()) {
            if (currentAst.getFirstChild() == null) continue;
            if (VariableDeclarationUsageDistanceCheck.isChild(currentAst, variableIdentAst)) {
                switch (currentAst.getType()) {
                    case 10: {
                        ++dist;
                        break;
                    }
                    case 7: {
                        dist = 0;
                        break;
                    }
                    case 83: 
                    case 84: 
                    case 85: 
                    case 89: 
                    case 91: {
                        if (VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(currentAst, variableIdentAst)) {
                            ++dist;
                            break;
                        }
                        dist = 0;
                        break;
                    }
                    default: {
                        if (currentAst.branchContains(7)) {
                            dist = 0;
                            break;
                        }
                        ++dist;
                    }
                }
                variableUsageAst = currentAst;
                firstUsageFound = true;
                continue;
            }
            if (currentAst.getType() == 10) continue;
            ++dist;
        }
        if (!firstUsageFound) {
            dist = 0;
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(variableUsageAst, dist);
    }

    private static Map.Entry<DetailAST, Integer> calculateDistanceBetweenScopes(DetailAST ast, DetailAST variable) {
        int dist = 0;
        DetailAST currentScopeAst = ast;
        DetailAST variableUsageAst = null;
        while (currentScopeAst != null) {
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            DetailAST currentStatementAst = currentScopeAst;
            currentScopeAst = null;
            while (currentStatementAst != null && currentStatementAst.getType() != 73) {
                if (currentStatementAst.getFirstChild() != null) {
                    if (VariableDeclarationUsageDistanceCheck.isChild(currentStatementAst, variable)) {
                        variableUsageExpressions.add(currentStatementAst);
                    } else if (variableUsageExpressions.isEmpty() && currentStatementAst.getType() != 10) {
                        ++dist;
                    }
                }
                currentStatementAst = currentStatementAst.getNextSibling();
            }
            if (variableUsageExpressions.size() == 1) {
                DetailAST blockWithVariableUsage = (DetailAST)variableUsageExpressions.get(0);
                DetailAST exprWithVariableUsage = null;
                switch (blockWithVariableUsage.getType()) {
                    case 10: 
                    case 28: {
                        ++dist;
                        break;
                    }
                    case 84: 
                    case 85: 
                    case 91: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideForWhileDoWhileBlocks(blockWithVariableUsage, variable);
                        break;
                    }
                    case 83: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideIfBlock(blockWithVariableUsage, variable);
                        break;
                    }
                    case 89: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideSwitchBlock(blockWithVariableUsage, variable);
                        break;
                    }
                    case 95: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideTryCatchFinallyBlocks(blockWithVariableUsage, variable);
                        break;
                    }
                    default: {
                        exprWithVariableUsage = blockWithVariableUsage.getFirstChild();
                    }
                }
                currentScopeAst = exprWithVariableUsage;
                if (exprWithVariableUsage != null) {
                    variableUsageAst = exprWithVariableUsage;
                    continue;
                }
                variableUsageAst = blockWithVariableUsage;
                continue;
            }
            if (variableUsageExpressions.size() > 1) {
                ++dist;
                variableUsageAst = (DetailAST)variableUsageExpressions.get(0);
                continue;
            }
            variableUsageAst = null;
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(variableUsageAst, dist);
    }

    private static DetailAST getFirstNodeInsideForWhileDoWhileBlocks(DetailAST block, DetailAST variable) {
        DetailAST firstNodeInsideBlock = null;
        if (!VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(block, variable)) {
            DetailAST currentNode = null;
            if (block.getType() == 85) {
                currentNode = block.getFirstChild();
            } else {
                currentNode = block.findFirstToken(77);
                if (currentNode != null) {
                    currentNode = currentNode.getNextSibling();
                }
            }
            if (currentNode != null) {
                int currentNodeType = currentNode.getType();
                if (currentNodeType == 7) {
                    firstNodeInsideBlock = currentNode.getFirstChild();
                } else if (currentNodeType != 10 && currentNodeType != 28) {
                    firstNodeInsideBlock = currentNode;
                }
            }
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstNodeInsideIfBlock(DetailAST block, DetailAST variable) {
        DetailAST firstNodeInsideBlock = null;
        if (!VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(block, variable)) {
            DetailAST currentNode = block.getLastChild();
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            while (currentNode != null && currentNode.getType() == 92) {
                DetailAST previousNode = currentNode.getPreviousSibling();
                if (VariableDeclarationUsageDistanceCheck.isChild(previousNode, variable)) {
                    variableUsageExpressions.add(previousNode);
                }
                if ((currentNode = currentNode.getFirstChild()).getType() == 83) {
                    currentNode = currentNode.getLastChild();
                    continue;
                }
                if (!VariableDeclarationUsageDistanceCheck.isChild(currentNode, variable)) continue;
                variableUsageExpressions.add(currentNode);
                currentNode = null;
            }
            if (currentNode != null && VariableDeclarationUsageDistanceCheck.isChild(currentNode, variable)) {
                variableUsageExpressions.add(currentNode);
            }
            if (variableUsageExpressions.size() == 1) {
                firstNodeInsideBlock = (DetailAST)variableUsageExpressions.get(0);
            }
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstNodeInsideSwitchBlock(DetailAST block, DetailAST variable) {
        DetailAST firstNodeInsideBlock = null;
        if (!VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(block, variable)) {
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            for (DetailAST currentNode = block.findFirstToken(33); currentNode != null && currentNode.getType() == 33; currentNode = currentNode.getNextSibling()) {
                DetailAST lastNodeInCaseGroup = currentNode.getLastChild();
                if (!VariableDeclarationUsageDistanceCheck.isChild(lastNodeInCaseGroup, variable)) continue;
                variableUsageExpressions.add(lastNodeInCaseGroup);
            }
            if (variableUsageExpressions.size() == 1) {
                firstNodeInsideBlock = (DetailAST)variableUsageExpressions.get(0);
            }
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstNodeInsideTryCatchFinallyBlocks(DetailAST block, DetailAST variable) {
        DetailAST finalBlock;
        DetailAST currentNode = block.getFirstChild();
        ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
        if (VariableDeclarationUsageDistanceCheck.isChild(currentNode, variable)) {
            variableUsageExpressions.add(currentNode);
        }
        for (currentNode = currentNode.getNextSibling(); currentNode != null && currentNode.getType() == 96; currentNode = currentNode.getNextSibling()) {
            DetailAST catchBlock = currentNode.getLastChild();
            if (!VariableDeclarationUsageDistanceCheck.isChild(catchBlock, variable)) continue;
            variableUsageExpressions.add(catchBlock);
        }
        if (currentNode != null && VariableDeclarationUsageDistanceCheck.isChild(finalBlock = currentNode.getLastChild(), variable)) {
            variableUsageExpressions.add(finalBlock);
        }
        DetailAST variableUsageNode = null;
        if (variableUsageExpressions.size() == 1) {
            variableUsageNode = ((DetailAST)variableUsageExpressions.get(0)).getFirstChild();
        }
        return variableUsageNode;
    }

    private static boolean isVariableInOperatorExpr(DetailAST operator, DetailAST variable) {
        boolean isVarInOperatorDeclr = false;
        DetailAST openingBracket = operator.findFirstToken(76);
        if (openingBracket != null) {
            DetailAST exprBetweenBrackets = openingBracket.getNextSibling();
            while (exprBetweenBrackets.getType() != 77) {
                if (VariableDeclarationUsageDistanceCheck.isChild(exprBetweenBrackets, variable)) {
                    isVarInOperatorDeclr = true;
                    break;
                }
                exprBetweenBrackets = exprBetweenBrackets.getNextSibling();
            }
            if (!isVarInOperatorDeclr) {
                block0 : switch (operator.getType()) {
                    case 83: {
                        DetailAST firstNodeInsideElseBlock;
                        DetailAST elseBlock = operator.getLastChild();
                        if (elseBlock.getType() != 92 || (firstNodeInsideElseBlock = elseBlock.getFirstChild()).getType() != 83) break;
                        isVarInOperatorDeclr |= VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(firstNodeInsideElseBlock, variable);
                        break;
                    }
                    case 89: {
                        for (DetailAST currentCaseBlock = operator.findFirstToken(33); currentCaseBlock != null && currentCaseBlock.getType() == 33; currentCaseBlock = currentCaseBlock.getNextSibling()) {
                            DetailAST firstNodeInsideCaseBlock = currentCaseBlock.getFirstChild();
                            if (!VariableDeclarationUsageDistanceCheck.isChild(firstNodeInsideCaseBlock, variable)) continue;
                            isVarInOperatorDeclr = true;
                            break block0;
                        }
                        break;
                    }
                }
            }
        }
        return isVarInOperatorDeclr;
    }

    private static boolean isChild(DetailAST parent, DetailAST ast) {
        boolean isChild = false;
        ASTEnumeration astList = parent.findAllPartial(ast);
        block0: while (astList.hasMoreNodes()) {
            DetailAST astNode = (DetailAST)astList.nextNode();
            for (DetailAST astParent = astNode.getParent(); astParent != null; astParent = astParent.getParent()) {
                if (!astParent.equals(parent) || astParent.getLineNo() != parent.getLineNo()) continue;
                isChild = true;
                continue block0;
            }
        }
        return isChild;
    }

    private boolean isVariableMatchesIgnorePattern(String variable) {
        Matcher matcher = this.ignoreVariablePattern.matcher(variable);
        return matcher.matches();
    }
}

