/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Set;

public class CovariantEqualsCheck
extends Check {
    public static final String MSG_KEY = "covariant.equals";
    private final Set<DetailAST> equalsMethods = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 136, 154};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 136, 154};
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.equalsMethods.clear();
        DetailAST objBlock = ast.findFirstToken(6);
        if (objBlock != null) {
            boolean hasEqualsObject = false;
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 9 || !CheckUtils.isEqualsMethod(child)) continue;
                if (CovariantEqualsCheck.isFirstParameterObject(child)) {
                    hasEqualsObject = true;
                    continue;
                }
                this.equalsMethods.add(child);
            }
            if (!hasEqualsObject) {
                for (DetailAST equalsAST : this.equalsMethods) {
                    DetailAST nameNode = equalsAST.findFirstToken(58);
                    this.log(nameNode.getLineNo(), nameNode.getColumnNo(), MSG_KEY, new Object[0]);
                }
            }
        }
    }

    private static boolean isFirstParameterObject(DetailAST methodDefAst) {
        DetailAST paramsNode = methodDefAst.findFirstToken(20);
        DetailAST paramNode = paramsNode.findFirstToken(21);
        DetailAST typeNode = paramNode.findFirstToken(13);
        FullIdent fullIdent = FullIdent.createFullIdentBelow(typeNode);
        String name = fullIdent.getText();
        return "Object".equals(name) || "java.lang.Object".equals(name);
    }
}

