/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class EmptyCatchBlockCheck
extends Check {
    public static final String MSG_KEY_CATCH_BLOCK_EMPTY = "catch.block.empty";
    private String exceptionVariableName = "^$";
    private String commentFormat = ".*";
    private Pattern variableNameRegexp = Pattern.compile(this.exceptionVariableName);
    private Pattern commentRegexp = Pattern.compile(this.commentFormat);

    public void setExceptionVariableName(String exceptionVariableName) {
        this.exceptionVariableName = exceptionVariableName;
        this.variableNameRegexp = Utils.createPattern(exceptionVariableName);
    }

    public void setCommentFormat(String commentFormat) {
        this.commentFormat = commentFormat;
        this.commentRegexp = Utils.createPattern(commentFormat);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{96};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.visitCatchBlock(ast);
    }

    private void visitCatchBlock(DetailAST catchAst) {
        String commentContent;
        if (EmptyCatchBlockCheck.isEmptyCatchBlock(catchAst) && this.isVerifiable(catchAst, commentContent = EmptyCatchBlockCheck.getCommentFirstLine(catchAst))) {
            this.log(catchAst.getLineNo(), MSG_KEY_CATCH_BLOCK_EMPTY, new Object[0]);
        }
    }

    private static String getCommentFirstLine(DetailAST catchAst) {
        DetailAST slistToken = catchAst.getLastChild();
        DetailAST firstElementInBlock = slistToken.getFirstChild();
        String commentContent = "";
        if (firstElementInBlock.getType() == 144) {
            commentContent = firstElementInBlock.getFirstChild().getText();
        } else if (firstElementInBlock.getType() == 145) {
            String[] lines;
            commentContent = firstElementInBlock.getFirstChild().getText();
            for (String line : lines = commentContent.split(System.getProperty("line.separator"))) {
                if (line.isEmpty()) continue;
                commentContent = line;
                break;
            }
        }
        return commentContent;
    }

    private boolean isVerifiable(DetailAST emptyCatchAst, String commentContent) {
        String exceptionVariableName = EmptyCatchBlockCheck.getExceptionVariableName(emptyCatchAst);
        boolean isMatchingVariableName = this.variableNameRegexp.matcher(exceptionVariableName).find();
        boolean isMatchingCommentContent = !commentContent.isEmpty() && this.commentRegexp.matcher(commentContent).find();
        return !isMatchingVariableName && !isMatchingCommentContent;
    }

    private static boolean isEmptyCatchBlock(DetailAST catchAst) {
        boolean result = true;
        DetailAST slistToken = catchAst.findFirstToken(7);
        DetailAST catchBlockStmt = slistToken.getFirstChild();
        while (catchBlockStmt.getType() != 73) {
            if (catchBlockStmt.getType() != 144 && catchBlockStmt.getType() != 145) {
                result = false;
                break;
            }
            catchBlockStmt = catchBlockStmt.getNextSibling();
        }
        return result;
    }

    private static String getExceptionVariableName(DetailAST catchAst) {
        DetailAST parameterDef = catchAst.findFirstToken(21);
        DetailAST variableName = parameterDef.findFirstToken(58);
        return variableName.getText();
    }
}

