/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class AbstractComplexityCheck
extends Check {
    private static final BigInteger INITIAL_VALUE = BigInteger.ONE;
    private final Deque<BigInteger> valueStack = new ArrayDeque<BigInteger>();
    private BigInteger currentValue = BigInteger.ZERO;
    private int max;

    public AbstractComplexityCheck(int max) {
        this.max = max;
    }

    protected abstract String getMessageID();

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{8, 9, 11, 12};
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int max) {
        this.max = max;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.visitMethodDef();
                break;
            }
            default: {
                this.visitTokenHook(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.leaveMethodDef(ast);
                break;
            }
            default: {
                this.leaveTokenHook(ast);
            }
        }
    }

    protected void visitTokenHook(DetailAST ast) {
    }

    protected void leaveTokenHook(DetailAST ast) {
    }

    protected final BigInteger getCurrentValue() {
        return this.currentValue;
    }

    protected final void setCurrentValue(BigInteger value) {
        this.currentValue = value;
    }

    protected final void incrementCurrentValue(BigInteger by) {
        this.setCurrentValue(this.getCurrentValue().add(by));
    }

    protected final void pushValue() {
        this.valueStack.push(this.currentValue);
        this.currentValue = INITIAL_VALUE;
    }

    protected final BigInteger popValue() {
        this.currentValue = this.valueStack.pop();
        return this.currentValue;
    }

    private void visitMethodDef() {
        this.pushValue();
    }

    private void leaveMethodDef(DetailAST ast) {
        BigInteger bigIntegerMax = BigInteger.valueOf(this.getMax());
        if (this.currentValue.compareTo(bigIntegerMax) > 0) {
            this.log(ast, this.getMessageID(), this.currentValue, bigIntegerMax);
        }
        this.popValue();
    }
}

