/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;

public class JavadocParagraphCheck
extends AbstractJavadocCheck {
    public static final String MSG_TAG_AFTER = "javadoc.paragraph.tag.after";
    public static final String MSG_LINE_BEFORE = "javadoc.paragraph.line.before";
    public static final String MSG_REDUNDANT_PARAGRAPH = "javadoc.paragraph.redundant.paragraph";
    public static final String MSG_MISPLACED_TAG = "javadoc.paragraph.misplaced.tag";
    private boolean tagImmediatelyBeforeFirstWord = true;

    public void setAllowNewlineParagraph(boolean value) {
        this.tagImmediatelyBeforeFirstWord = value;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{6, 10001};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (ast.getType() == 6 && JavadocParagraphCheck.isEmptyLine(ast)) {
            this.checkEmptyLine(ast);
        } else if (ast.getType() == 10001 && JavadocUtils.getFirstChild(ast).getType() == 10006) {
            this.checkParagraphTag(ast);
        }
    }

    private void checkEmptyLine(DetailNode newline) {
        DetailNode nearestToken = JavadocParagraphCheck.getNearestNode(newline);
        if (!JavadocParagraphCheck.isLastEmptyLine(newline) && nearestToken.getChildren().length > 1) {
            this.log(newline.getLineNumber(), MSG_TAG_AFTER, new Object[0]);
        }
    }

    private void checkParagraphTag(DetailNode tag) {
        DetailNode newLine = JavadocParagraphCheck.getNearestEmptyLine(tag);
        if (JavadocParagraphCheck.isFirstParagraph(tag)) {
            this.log(tag.getLineNumber(), MSG_REDUNDANT_PARAGRAPH, new Object[0]);
        } else if (newLine == null || tag.getLineNumber() - newLine.getLineNumber() != 1) {
            this.log(tag.getLineNumber(), MSG_LINE_BEFORE, new Object[0]);
        }
        if (this.tagImmediatelyBeforeFirstWord && JavadocParagraphCheck.isImmediatelyFollowedByText(tag)) {
            this.log(tag.getLineNumber(), MSG_MISPLACED_TAG, new Object[0]);
        }
    }

    private static DetailNode getNearestNode(DetailNode node) {
        DetailNode tag = JavadocUtils.getNextSibling(node);
        while (tag.getType() == 1 || tag.getType() == 6) {
            tag = JavadocUtils.getNextSibling(tag);
        }
        return tag;
    }

    private static boolean isEmptyLine(DetailNode newLine) {
        DetailNode previousSibling = JavadocUtils.getPreviousSibling(newLine);
        if (previousSibling == null || previousSibling.getParent().getType() != 10000) {
            return false;
        }
        if (previousSibling.getType() == 10074 && previousSibling.getChildren().length == 1) {
            previousSibling = JavadocUtils.getPreviousSibling(previousSibling);
        }
        return previousSibling != null && previousSibling.getType() == 1;
    }

    private static boolean isFirstParagraph(DetailNode paragraphTag) {
        DetailNode previousNode = JavadocUtils.getPreviousSibling(paragraphTag);
        while (previousNode != null) {
            if (previousNode.getType() == 10074 && previousNode.getChildren().length > 1 || previousNode.getType() != 1 && previousNode.getType() != 6 && previousNode.getType() != 10074) {
                return false;
            }
            previousNode = JavadocUtils.getPreviousSibling(previousNode);
        }
        return true;
    }

    private static DetailNode getNearestEmptyLine(DetailNode node) {
        DetailNode newLine = JavadocUtils.getPreviousSibling(node);
        while (newLine != null) {
            DetailNode previousSibling = JavadocUtils.getPreviousSibling(newLine);
            if (newLine.getType() == 6 && JavadocParagraphCheck.isEmptyLine(newLine)) break;
            newLine = previousSibling;
        }
        return newLine;
    }

    private static boolean isLastEmptyLine(DetailNode newLine) {
        DetailNode nextNode = JavadocUtils.getNextSibling(newLine);
        while (nextNode != null && nextNode.getType() != 10071) {
            if (nextNode.getType() == 10074 && nextNode.getChildren().length > 1 || nextNode.getType() == 10001) {
                return false;
            }
            nextNode = JavadocUtils.getNextSibling(nextNode);
        }
        return true;
    }

    private static boolean isImmediatelyFollowedByText(DetailNode tag) {
        DetailNode nextSibling = JavadocUtils.getNextSibling(tag);
        return nextSibling.getType() == 6 || nextSibling.getType() == -1 || nextSibling.getText().startsWith(" ");
    }
}

