/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import java.util.BitSet;

public class IndentLevel {
    private final BitSet levels = new BitSet();

    public IndentLevel(int indent) {
        this.levels.set(indent);
    }

    public IndentLevel(IndentLevel base, int ... offsets) {
        BitSet src = base.levels;
        int i = src.nextSetBit(0);
        while (i >= 0) {
            for (int offset : offsets) {
                this.levels.set(i + offset);
            }
            i = src.nextSetBit(i + 1);
        }
    }

    public final boolean isMultiLevel() {
        return this.levels.cardinality() > 1;
    }

    public boolean accept(int indent) {
        return this.levels.get(indent);
    }

    public boolean greaterThan(int indent) {
        return this.levels.nextSetBit(0) > indent;
    }

    public void addAcceptedIndent(int indent) {
        this.levels.set(indent);
    }

    public void addAcceptedIndent(IndentLevel indent) {
        this.levels.or(indent.levels);
    }

    public int getFirstIndentLevel() {
        return this.levels.nextSetBit(0);
    }

    public int getLastIndentLevel() {
        return this.levels.length() - 1;
    }

    public String toString() {
        if (this.levels.cardinality() == 1) {
            return String.valueOf(this.levels.nextSetBit(0));
        }
        StringBuilder sb = new StringBuilder();
        int i = this.levels.nextSetBit(0);
        while (i >= 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(i);
            i = this.levels.nextSetBit(i + 1);
        }
        return sb.toString();
    }
}

