/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class HideUtilityClassConstructorCheck
extends Check {
    public static final String MSG_KEY = "hide.utility.class";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14};
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isUtilClass;
        if (HideUtilityClassConstructorCheck.isAbstract(ast)) {
            return;
        }
        boolean hasStaticModifier = HideUtilityClassConstructorCheck.isStatic(ast);
        Details details = new Details(ast);
        details.invoke();
        boolean hasDefaultCtor = details.isHasDefaultCtor();
        boolean hasPublicCtor = details.isHasPublicCtor();
        boolean hasMethodOrField = details.isHasMethodOrField();
        boolean hasNonStaticMethodOrField = details.isHasNonStaticMethodOrField();
        boolean hasNonPrivateStaticMethodOrField = details.isHasNonPrivateStaticMethodOrField();
        boolean hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
        boolean extendsJLO = ast.findFirstToken(18) == null;
        boolean bl = isUtilClass = extendsJLO && hasMethodOrField && !hasNonStaticMethodOrField && hasNonPrivateStaticMethodOrField;
        if (isUtilClass && hasAccessibleCtor && !hasStaticModifier) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isAbstract(DetailAST ast) {
        return ast.findFirstToken(5).branchContains(40);
    }

    private static boolean isStatic(DetailAST ast) {
        return ast.findFirstToken(5).branchContains(64);
    }

    private static class Details {
        private final DetailAST ast;
        private boolean hasMethodOrField;
        private boolean hasNonStaticMethodOrField;
        private boolean hasNonPrivateStaticMethodOrField;
        private boolean hasDefaultCtor;
        private boolean hasPublicCtor;

        public Details(DetailAST ast) {
            this.ast = ast;
        }

        public boolean isHasMethodOrField() {
            return this.hasMethodOrField;
        }

        public boolean isHasNonStaticMethodOrField() {
            return this.hasNonStaticMethodOrField;
        }

        public boolean isHasNonPrivateStaticMethodOrField() {
            return this.hasNonPrivateStaticMethodOrField;
        }

        public boolean isHasDefaultCtor() {
            return this.hasDefaultCtor;
        }

        public boolean isHasPublicCtor() {
            return this.hasPublicCtor;
        }

        public void invoke() {
            DetailAST objBlock = this.ast.findFirstToken(6);
            this.hasMethodOrField = false;
            this.hasNonStaticMethodOrField = false;
            this.hasNonPrivateStaticMethodOrField = false;
            this.hasDefaultCtor = true;
            this.hasPublicCtor = false;
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                DetailAST modifiers;
                int type = child.getType();
                if (type == 9 || type == 10) {
                    this.hasMethodOrField = true;
                    modifiers = child.findFirstToken(5);
                    boolean isStatic = modifiers.branchContains(64);
                    boolean isPrivate = modifiers.branchContains(61);
                    if (!isStatic) {
                        this.hasNonStaticMethodOrField = true;
                    }
                    if (isStatic && !isPrivate) {
                        this.hasNonPrivateStaticMethodOrField = true;
                    }
                }
                if (type != 8) continue;
                this.hasDefaultCtor = false;
                modifiers = child.findFirstToken(5);
                if (modifiers.branchContains(61) || modifiers.branchContains(63)) continue;
                this.hasPublicCtor = true;
            }
        }
    }
}

