/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.Set;

public class ClassResolver {
    private final String pkg;
    private final Set<String> imports;
    private final ClassLoader loader;

    public ClassResolver(ClassLoader loader, String pkg, Set<String> imports) {
        this.loader = loader;
        this.pkg = pkg;
        this.imports = imports;
        imports.add("java.lang.*");
    }

    public Class<?> resolve(String name, String currentClass) throws ClassNotFoundException {
        Class<?> clazz = this.resolveQualifiedName(name);
        if (clazz != null) {
            return clazz;
        }
        for (String imp : this.imports) {
            if (!imp.endsWith("." + name) || (clazz = this.resolveQualifiedName(imp)) == null) continue;
            return clazz;
        }
        if (!"".equals(this.pkg) && (clazz = this.resolveQualifiedName(this.pkg + "." + name)) != null) {
            return clazz;
        }
        clazz = this.resolveInnerClass(name, currentClass);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.resolveByStarImports(name);
        if (clazz != null) {
            return clazz;
        }
        return this.safeLoad(name);
    }

    private Class<?> resolveInnerClass(String name, String currentClass) throws ClassNotFoundException {
        String innerClass;
        Class<?> clazz = null;
        if (!"".equals(currentClass) && this.isLoadable(innerClass = (!"".equals(this.pkg) ? this.pkg + "." : "") + currentClass + "$" + name)) {
            clazz = this.safeLoad(innerClass);
        }
        return clazz;
    }

    private Class<?> resolveByStarImports(String name) {
        Class<?> clazz = null;
        for (String imp : this.imports) {
            String fqn;
            if (imp.endsWith(".*") && (clazz = this.resolveQualifiedName(fqn = imp.substring(0, imp.lastIndexOf(46) + 1) + name)) != null) break;
        }
        return clazz;
    }

    public boolean isLoadable(String name) {
        try {
            this.safeLoad(name);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public Class<?> safeLoad(String name) throws ClassNotFoundException, NoClassDefFoundError {
        return Class.forName(name, false, this.loader);
    }

    private Class<?> resolveQualifiedName(String name) {
        try {
            String innerName;
            if (this.isLoadable(name)) {
                return this.safeLoad(name);
            }
            int dot = name.lastIndexOf(46);
            if (dot != -1 && this.isLoadable(innerName = name.substring(0, dot) + "$" + name.substring(dot + 1))) {
                return this.safeLoad(innerName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }
}

