/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.regex.Pattern;

public class JavadocVariableCheck
extends Check {
    public static final String JAVADOC_MISSING = "javadoc.missing";
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern ignoreNamePattern;

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String scope) {
        this.excludeScope = Scope.getInstance(scope);
    }

    public void setIgnoreNamePattern(String regexp) {
        this.ignoreNamePattern = Utils.createPattern(regexp);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10, 155};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 155};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FileContents contents;
        TextBlock cmt;
        if (this.shouldCheck(ast) && (cmt = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) == null) {
            this.log(ast, JAVADOC_MISSING, new Object[0]);
        }
    }

    private boolean isIgnored(DetailAST ast) {
        String name = ast.findFirstToken(58).getText();
        return this.ignoreNamePattern != null && this.ignoreNamePattern.matcher(name).matches();
    }

    private boolean shouldCheck(DetailAST ast) {
        Scope scope;
        if (ScopeUtils.inCodeBlock(ast) || this.isIgnored(ast)) {
            return false;
        }
        if (ast.getType() == 155) {
            scope = Scope.PUBLIC;
        } else {
            DetailAST mods = ast.findFirstToken(5);
            Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
            scope = ScopeUtils.inInterfaceOrAnnotationBlock(ast) ? Scope.PUBLIC : declaredScope;
        }
        Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
        return scope.isIn(this.scope) && surroundingScope.isIn(this.scope) && (this.excludeScope == null || !scope.isIn(this.excludeScope) || !surroundingScope.isIn(this.excludeScope));
    }
}

