/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EqualsAvoidNullCheck
extends Check {
    public static final String MSG_EQUALS_AVOID_NULL = "equals.avoid.null";
    public static final String MSG_EQUALS_IGNORE_CASE_AVOID_NULL = "equalsIgnoreCase.avoid.null";
    private boolean ignoreEqualsIgnoreCase;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST methodCall) {
        DetailAST dot = methodCall.getFirstChild();
        if (dot.getType() != 59) {
            return;
        }
        DetailAST objCalledOn = dot.getFirstChild();
        if (EqualsAvoidNullCheck.isStringLiteral(objCalledOn)) {
            return;
        }
        DetailAST method = objCalledOn.getNextSibling();
        DetailAST expr = dot.getNextSibling().getFirstChild();
        if ("equals".equals(method.getText()) && EqualsAvoidNullCheck.containsOneArgument(methodCall) && EqualsAvoidNullCheck.containsAllSafeTokens(expr)) {
            this.log(methodCall.getLineNo(), methodCall.getColumnNo(), MSG_EQUALS_AVOID_NULL, new Object[0]);
        }
        if (!this.ignoreEqualsIgnoreCase && "equalsIgnoreCase".equals(method.getText()) && EqualsAvoidNullCheck.containsOneArgument(methodCall) && EqualsAvoidNullCheck.containsAllSafeTokens(expr)) {
            this.log(methodCall.getLineNo(), methodCall.getColumnNo(), MSG_EQUALS_IGNORE_CASE_AVOID_NULL, new Object[0]);
        }
    }

    private static boolean containsOneArgument(DetailAST methodCall) {
        DetailAST elist = methodCall.findFirstToken(34);
        return elist.getChildCount() == 1;
    }

    private static boolean isStringLiteral(DetailAST objCalledOn) {
        return objCalledOn.getType() == 139 || objCalledOn.getType() == 136 || objCalledOn.getType() == 59;
    }

    private static boolean containsAllSafeTokens(DetailAST expr) {
        DetailAST arg = expr.getFirstChild();
        if (arg.branchContains(27)) {
            return false;
        }
        return !(arg = EqualsAvoidNullCheck.skipVariableAssign(arg)).branchContains(98) && !arg.branchContains(58);
    }

    private static DetailAST skipVariableAssign(DetailAST currentAST) {
        if (currentAST.getType() == 80 && currentAST.getFirstChild().getType() == 58) {
            return currentAST.getFirstChild().getNextSibling();
        }
        return currentAST;
    }

    public void setIgnoreEqualsIgnoreCase(boolean newValue) {
        this.ignoreEqualsIgnoreCase = newValue;
    }
}

