/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;

public final class SeverityLevelCounter
implements AuditListener {
    private final SeverityLevel level;
    private int count;

    public SeverityLevelCounter(SeverityLevel level) {
        if (level == null) {
            throw new IllegalArgumentException();
        }
        this.level = level;
    }

    @Override
    public void addError(AuditEvent evt) {
        if (this.level == evt.getSeverityLevel()) {
            ++this.count;
        }
    }

    @Override
    public void addException(AuditEvent evt, Throwable throwable) {
        if (SeverityLevel.ERROR == this.level) {
            ++this.count;
        }
    }

    @Override
    public void auditStarted(AuditEvent evt) {
        this.count = 0;
    }

    @Override
    public void fileStarted(AuditEvent evt) {
    }

    @Override
    public void auditFinished(AuditEvent evt) {
    }

    @Override
    public void fileFinished(AuditEvent evt) {
    }

    public int getCount() {
        return this.count;
    }
}

