/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.filters.IntFilter;
import java.util.Objects;

class IntRangeFilter
implements IntFilter {
    private final Integer lowerBound;
    private final Integer upperBound;

    public IntRangeFilter(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean accept(int intValue) {
        return this.lowerBound.compareTo(intValue) <= 0 && this.upperBound.compareTo(intValue) >= 0;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntRangeFilter that = (IntRangeFilter)o;
        return Objects.equals(this.lowerBound, that.lowerBound) && Objects.equals(this.upperBound, that.upperBound);
    }
}

