/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SuppressionsLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Suppressions 1.0//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/suppressions_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Suppressions 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/suppressions_1_1.dtd";
    private final FilterSet filterChain = new FilterSet();

    private SuppressionsLoader() throws ParserConfigurationException, SAXException {
        super(SuppressionsLoader.createIdToResourceNameMap());
    }

    public FilterSet getFilterChain() {
        return this.filterChain;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("suppress".equals(qName)) {
            String columns;
            SuppressElement suppress;
            String checks = atts.getValue("checks");
            String modId = atts.getValue("id");
            if (checks == null && modId == null) {
                throw new SAXException("missing checks and id attribute");
            }
            try {
                String files = atts.getValue("files");
                suppress = new SuppressElement(files);
                if (modId != null) {
                    suppress.setModuleId(modId);
                }
                if (checks != null) {
                    suppress.setChecks(checks);
                }
            }
            catch (PatternSyntaxException e) {
                throw new SAXException("invalid files or checks format");
            }
            String lines = atts.getValue("lines");
            if (lines != null) {
                suppress.setLines(lines);
            }
            if ((columns = atts.getValue("columns")) != null) {
                suppress.setColumns(columns);
            }
            this.filterChain.addFilter(suppress);
        }
    }

    public static FilterSet loadSuppressions(String filename) throws CheckstyleException {
        URI uri;
        try {
            URL url = new URL(filename);
            uri = url.toURI();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            uri = null;
        }
        if (uri == null) {
            File file = new File(filename);
            if (file.exists()) {
                uri = file.toURI();
            } else {
                try {
                    URL configUrl = SuppressionsLoader.class.getResource(filename);
                    if (configUrl == null) {
                        throw new CheckstyleException("unable to find " + filename);
                    }
                    uri = configUrl.toURI();
                }
                catch (URISyntaxException e) {
                    throw new CheckstyleException("unable to find " + filename, e);
                }
            }
        }
        InputSource source = new InputSource(uri.toString());
        return SuppressionsLoader.loadSuppressions(source, filename);
    }

    private static FilterSet loadSuppressions(InputSource source, String sourceName) throws CheckstyleException {
        try {
            SuppressionsLoader suppressionsLoader = new SuppressionsLoader();
            suppressionsLoader.parseInputSource(source);
            return suppressionsLoader.getFilterChain();
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + sourceName, e);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new CheckstyleException("unable to parse " + sourceName + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + sourceName, e);
        }
        catch (NumberFormatException e) {
            throw new CheckstyleException("number format exception " + sourceName + " - " + e.getMessage(), e);
        }
    }

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap<String, String> map = Maps.newHashMap();
        map.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        return map;
    }
}

