/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;

public class JavadocTag {
    private final int lineNo;
    private final int columnNo;
    private final String arg1;
    private final JavadocTagInfo tagInfo;

    public JavadocTag(int line, int column, String tag, String arg1) {
        this.lineNo = line;
        this.columnNo = column;
        this.arg1 = arg1;
        this.tagInfo = JavadocTagInfo.fromName(tag);
    }

    public JavadocTag(int line, int column, String tag) {
        this(line, column, tag, null);
    }

    public String getTagName() {
        return this.tagInfo.getName();
    }

    public String getArg1() {
        return this.arg1;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return "JavadocTag{tag='" + this.getTagName() + "' lineNo=" + this.lineNo + ", columnNo=" + this.columnNo + ", arg1='" + this.arg1 + "'}";
    }

    public boolean isReturnTag() {
        return JavadocTagInfo.RETURN == this.tagInfo;
    }

    public boolean isParamTag() {
        return JavadocTagInfo.PARAM == this.tagInfo;
    }

    public boolean isThrowsTag() {
        return JavadocTagInfo.THROWS == this.tagInfo || JavadocTagInfo.EXCEPTION == this.tagInfo;
    }

    public boolean isSeeOrInheritDocTag() {
        return JavadocTagInfo.SEE == this.tagInfo || this.isInheritDocTag();
    }

    public boolean isInheritDocTag() {
        return JavadocTagInfo.INHERIT_DOC == this.tagInfo;
    }

    public boolean canReferenceImports() {
        return JavadocTagInfo.SEE == this.tagInfo || JavadocTagInfo.LINK == this.tagInfo || JavadocTagInfo.LINKPLAIN == this.tagInfo || JavadocTagInfo.THROWS == this.tagInfo || JavadocTagInfo.EXCEPTION == this.tagInfo;
    }
}

