/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;

public class OuterTypeFilenameCheck
extends Check {
    private boolean seenFirstToken;
    private String fileName;
    private boolean hasPublic;
    private boolean validFirst;
    private DetailAST wrongType;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157};
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.fileName = this.getFileName();
        this.seenFirstToken = false;
        this.validFirst = false;
        this.hasPublic = false;
        this.wrongType = null;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String outerTypeName = ast.findFirstToken(58).getText();
        if (!this.seenFirstToken) {
            if (this.fileName.equals(outerTypeName)) {
                this.validFirst = true;
            } else {
                this.wrongType = ast;
            }
        } else {
            DetailAST modifiers = ast.findFirstToken(5);
            if (modifiers.findFirstToken(62) != null && ast.getParent() == null) {
                this.hasPublic = true;
            }
        }
        this.seenFirstToken = true;
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (!this.validFirst && !this.hasPublic && this.wrongType != null) {
            this.log(this.wrongType.getLineNo(), "type.file.mismatch", new Object[0]);
        }
    }

    private String getFileName() {
        String fname = this.getFileContents().getFileName();
        fname = fname.substring(fname.lastIndexOf(File.separatorChar) + 1);
        fname = fname.replaceAll("\\.[^\\.]*$", "");
        return fname;
    }
}

