/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class DefaultLogger
extends AutomaticBean
implements AuditListener {
    private static final int BUFFER_CUSHION = 12;
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;

    public DefaultLogger(OutputStream os, boolean closeStreamsAfterUse) throws UnsupportedEncodingException {
        this(os, closeStreamsAfterUse, os, false);
    }

    public DefaultLogger(OutputStream infoStream, boolean closeInfoAfterUse, OutputStream errorStream, boolean closeErrorAfterUse) throws UnsupportedEncodingException {
        this.closeInfo = closeInfoAfterUse;
        this.closeError = closeErrorAfterUse;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, "UTF-8");
        OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, "UTF-8");
        this.infoWriter = new PrintWriter(infoStreamWriter);
        this.errorWriter = infoStream == errorStream ? this.infoWriter : new PrintWriter(errorStreamWriter);
    }

    @Override
    public void addError(AuditEvent evt) {
        SeverityLevel severityLevel = evt.getSeverityLevel();
        if (SeverityLevel.IGNORE != severityLevel) {
            String fileName = evt.getFileName();
            String message = evt.getMessage();
            int bufLen = fileName.length() + message.length() + 12;
            StringBuilder sb = new StringBuilder(bufLen);
            sb.append(fileName).append(':').append(evt.getLine());
            if (evt.getColumn() > 0) {
                sb.append(':').append(evt.getColumn());
            }
            if (SeverityLevel.WARNING == severityLevel) {
                sb.append(": warning");
            }
            sb.append(": ").append(message);
            this.errorWriter.println(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent evt, Throwable throwable) {
        PrintWriter printWriter = this.errorWriter;
        synchronized (printWriter) {
            this.errorWriter.println("Error auditing " + evt.getFileName());
            throwable.printStackTrace(this.errorWriter);
        }
    }

    @Override
    public void auditStarted(AuditEvent evt) {
        this.infoWriter.println("Starting audit...");
    }

    @Override
    public void fileFinished(AuditEvent evt) {
    }

    @Override
    public void fileStarted(AuditEvent evt) {
    }

    @Override
    public void auditFinished(AuditEvent evt) {
        this.infoWriter.println("Audit done.");
        this.closeStreams();
    }

    protected void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }
}

