/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.CSVFilter;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;

public class SuppressElement
implements Filter {
    private final transient Pattern fileRegexp;
    private final String filePattern;
    private transient Pattern checkRegexp;
    private String checkPattern;
    private String moduleId;
    private transient CSVFilter lineFilter;
    private String linesCSV;
    private transient CSVFilter columnFilter;
    private String columnsCSV;

    public SuppressElement(String files) throws ConversionException {
        this.filePattern = files;
        this.fileRegexp = Pattern.compile(files);
    }

    public void setChecks(String checks) throws ConversionException {
        this.checkPattern = checks;
        this.checkRegexp = Utils.createPattern(checks);
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setLines(String lines) {
        this.linesCSV = lines;
        this.lineFilter = lines != null ? new CSVFilter(lines) : null;
    }

    public void setColumns(String columns) {
        this.columnsCSV = columns;
        this.columnFilter = columns != null ? new CSVFilter(columns) : null;
    }

    @Override
    public boolean accept(AuditEvent event) {
        if (this.isFileNameAndModuleMatching(event)) {
            return true;
        }
        if (this.lineFilter == null && this.columnFilter == null) {
            return false;
        }
        if (this.lineFilter != null && this.lineFilter.accept(event.getLine())) {
            return false;
        }
        return this.columnFilter == null || !this.columnFilter.accept(event.getColumn());
    }

    private boolean isFileNameAndModuleMatching(AuditEvent event) {
        return event.getFileName() == null || !this.fileRegexp.matcher(event.getFileName()).find() || event.getLocalizedMessage() == null || this.moduleId != null && !this.moduleId.equals(event.getModuleId()) || this.checkRegexp != null && !this.checkRegexp.matcher(event.getSourceName()).find();
    }

    public int hashCode() {
        return Objects.hash(this.filePattern, this.checkPattern, this.moduleId, this.linesCSV, this.columnsCSV);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuppressElement that = (SuppressElement)o;
        return Objects.equals(this.filePattern, that.filePattern) && Objects.equals(this.checkPattern, that.checkPattern) && Objects.equals(this.moduleId, that.moduleId) && Objects.equals(this.linesCSV, that.linesCSV) && Objects.equals(this.columnsCSV, that.columnsCSV);
    }
}

