/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;

public class InnerAssignmentCheck
extends Check {
    public static final String MSG_KEY = "assignment.inner.avoid";
    private static final int[][] ALLOWED_ASSIGMENT_CONTEXT = new int[][]{{28, 7}, {10}, {28, 34, 35}, {28, 34, 37}, {160}, {178, 177, 176}, {28, 181}};
    private static final int[][] CONTROL_CONTEXT = new int[][]{{28, 85}, {28, 91}, {28, 84}, {28, 83}, {28, 92}};
    private static final int[][] ALLOWED_ASSIGMENT_IN_COMPARISON_CONTEXT = new int[][]{{28, 84}};
    private static final int[] COMPARISON_TYPES = new int[]{116, 120, 118, 119, 117, 115};

    @Override
    public int[] getDefaultTokens() {
        return new int[]{80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (InnerAssignmentCheck.isInContext(ast, ALLOWED_ASSIGMENT_CONTEXT)) {
            return;
        }
        if (InnerAssignmentCheck.isInNoBraceControlStatement(ast)) {
            return;
        }
        if (this.isInWhileIdiom(ast)) {
            return;
        }
        this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
    }

    private static boolean isInNoBraceControlStatement(DetailAST ast) {
        if (!InnerAssignmentCheck.isInContext(ast, CONTROL_CONTEXT)) {
            return false;
        }
        DetailAST expr = ast.getParent();
        DetailAST exprNext = expr.getNextSibling();
        return exprNext != null && exprNext.getType() == 45;
    }

    private boolean isInWhileIdiom(DetailAST ast) {
        if (!InnerAssignmentCheck.isComparison(ast.getParent())) {
            return false;
        }
        return InnerAssignmentCheck.isInContext(ast.getParent(), ALLOWED_ASSIGMENT_IN_COMPARISON_CONTEXT);
    }

    private static boolean isComparison(DetailAST ast) {
        int astType = ast.getType();
        return Arrays.binarySearch(COMPARISON_TYPES, astType) >= 0;
    }

    private static boolean isInContext(DetailAST ast, int[] ... contextSet) {
        block0: for (int[] element : contextSet) {
            DetailAST current = ast;
            int len = element.length;
            for (int j = 0; j < len; ++j) {
                current = current.getParent();
                int expectedType = element[j];
                if (current == null || current.getType() != expectedType) continue block0;
                if (j != len - 1) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Arrays.sort(COMPARISON_TYPES);
    }
}

