/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import java.util.Map;

public enum JavadocTagInfo {
    AUTHOR("@author", "author", Type.BLOCK, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157;
        }
    }
    ,
    CODE("{@code}", "code", Type.INLINE, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    DOC_ROOT("{@docRoot}", "docRoot", Type.INLINE, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    DEPRECATED("@deprecated", "deprecated", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 155 || type == 161 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    EXCEPTION("@exception", "exception", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 9 || type == 8;
        }
    }
    ,
    INHERIT_DOC("{@inheritDoc}", "inheritDoc", Type.INLINE, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 9 && !ast.branchContains(64) && ScopeUtils.getScopeFromMods(ast.findFirstToken(5)) != Scope.PRIVATE;
        }
    }
    ,
    LINK("{@link}", "link", Type.INLINE, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    LINKPLAIN("{@linkplain}", "linkplain", Type.INLINE, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    LITERAL("{@literal}", "literal", Type.INLINE, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    PARAM("@param", "param", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 14 || type == 15 || type == 9 || type == 8;
        }
    }
    ,
    RETURN("@return", "return", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            DetailAST returnType = ast.findFirstToken(13);
            return type == 9 && returnType.getFirstChild().getType() != 49;
        }
    }
    ,
    SEE("@see", "see", Type.BLOCK, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    SERIAL("@serial", "serial", Type.BLOCK, true, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    SERIAL_DATA("@serialData", "serialData", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            DetailAST methodNameAst = ast.findFirstToken(58);
            String methodName = methodNameAst.getText();
            return type == 9 && ("writeObject".equals(methodName) || "readObject".equals(methodName) || "writeExternal".equals(methodName) || "readExternal".equals(methodName) || "writeReplace".equals(methodName) || "readResolve".equals(methodName));
        }
    }
    ,
    SERIAL_FIELD("@serialField", "serialField", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            DetailAST varType = ast.findFirstToken(13);
            return type == 10 && varType.getType() == 17 && "ObjectStreafield".equals(varType.getFirstChild().getText());
        }
    }
    ,
    SINCE("@since", "since", Type.BLOCK, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    THROWS("@throws", "throws", Type.BLOCK, false, false){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 9 || type == 8;
        }
    }
    ,
    VALUE("{@value}", "value", Type.INLINE, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    VERSION("@version", "version", Type.BLOCK, true, true){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157;
        }
    };

    private static final Map<String, JavadocTagInfo> TEXT_TO_TAG;
    private static final Map<String, JavadocTagInfo> NAME_TO_TAG;
    private final String text;
    private final String name;
    private final Type type;
    private final boolean validInPackageHtml;
    private final boolean validInOverviewHtml;

    private JavadocTagInfo(String text, String name, Type type, boolean validInPackageHtml, boolean validInOverviewHtml) {
        this.text = text;
        this.name = name;
        this.type = type;
        this.validInPackageHtml = validInPackageHtml;
        this.validInOverviewHtml = validInOverviewHtml;
    }

    public abstract boolean isValidOn(DetailAST var1);

    public boolean isValidInPackageHtml() {
        return this.validInPackageHtml;
    }

    public boolean isValidInOverviewHtml() {
        return this.validInOverviewHtml;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public static JavadocTagInfo fromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("the text is null");
        }
        JavadocTagInfo tag = TEXT_TO_TAG.get(text);
        if (tag == null) {
            throw new IllegalArgumentException("the text [" + text + "] is not a valid Javadoc tag text");
        }
        return tag;
    }

    public static JavadocTagInfo fromName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("the name is null");
        }
        JavadocTagInfo tag = NAME_TO_TAG.get(name);
        if (tag == null) {
            throw new IllegalArgumentException("the name [" + name + "] is not a valid Javadoc tag name");
        }
        return tag;
    }

    public static boolean isValidName(String name) {
        return NAME_TO_TAG.containsKey(name);
    }

    public String toString() {
        return "text [" + this.text + "] name [" + this.name + "] type [" + (Object)((Object)this.type) + "] validInPackageHtml [" + this.validInPackageHtml + "] validInOverviewHtml [" + this.validInOverviewHtml + "]";
    }

    static {
        ImmutableMap.Builder<String, JavadocTagInfo> textToTagBuilder = new ImmutableMap.Builder<String, JavadocTagInfo>();
        ImmutableMap.Builder<String, JavadocTagInfo> nameToTagBuilder = new ImmutableMap.Builder<String, JavadocTagInfo>();
        for (JavadocTagInfo tag : JavadocTagInfo.values()) {
            textToTagBuilder.put(tag.getText(), tag);
            nameToTagBuilder.put(tag.getName(), tag);
        }
        TEXT_TO_TAG = textToTagBuilder.build();
        NAME_TO_TAG = nameToTagBuilder.build();
    }

    public static enum Type {
        BLOCK,
        INLINE;

    }
}

