/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceAfterCheck
extends Check {
    public static final String MSG_KEY = "ws.followed";
    private boolean allowLineBreaks = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59, 17};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59, 23, 17};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST astNode = ast;
        if (ast.getType() == 17 || ast.getType() == 23) {
            astNode = NoWhitespaceAfterCheck.getPreceded(ast);
        }
        String line = this.getLine(ast.getLineNo() - 1);
        int after = NoWhitespaceAfterCheck.getPositionAfter(astNode);
        if ((after >= line.length() || Character.isWhitespace(line.charAt(after))) && this.hasRedundantWhitespace(line, after)) {
            this.log(astNode.getLineNo(), after, MSG_KEY, astNode.getText());
        }
    }

    private static DetailAST getPreceded(DetailAST arrayOrTypeCast) {
        DetailAST preceded = arrayOrTypeCast;
        switch (arrayOrTypeCast.getType()) {
            case 23: {
                preceded = arrayOrTypeCast.findFirstToken(77);
                break;
            }
            case 17: {
                preceded = NoWhitespaceAfterCheck.getArrayTypeOrIdentifier(arrayOrTypeCast);
                break;
            }
            default: {
                throw new IllegalStateException(arrayOrTypeCast.toString());
            }
        }
        return preceded;
    }

    private static int getPositionAfter(DetailAST ast) {
        int after;
        if (ast.getType() == 58 && ast.getNextSibling() != null && ast.getNextSibling().getType() == 76) {
            DetailAST methodDef = ast.getParent();
            DetailAST endOfParams = methodDef.findFirstToken(77);
            after = endOfParams.getColumnNo() + 1;
        } else {
            after = ast.getColumnNo() + ast.getText().length();
        }
        return after;
    }

    private static DetailAST getArrayTypeOrIdentifier(DetailAST arrayDeclarator) {
        DetailAST typeOrIdent = arrayDeclarator;
        if (NoWhitespaceAfterCheck.isArrayInstantiation(arrayDeclarator)) {
            typeOrIdent = arrayDeclarator.getParent().getFirstChild();
        } else if (NoWhitespaceAfterCheck.isMultiDimensionalArray(arrayDeclarator)) {
            if (NoWhitespaceAfterCheck.isCstyleMultiDimensionalArrayDeclaration(arrayDeclarator)) {
                if (arrayDeclarator.getParent().getType() != 17) {
                    typeOrIdent = NoWhitespaceAfterCheck.getArrayIdentifier(arrayDeclarator);
                }
            } else {
                for (DetailAST arrayIdentifier = arrayDeclarator.getFirstChild(); arrayIdentifier != null; arrayIdentifier = arrayIdentifier.getFirstChild()) {
                    typeOrIdent = arrayIdentifier;
                }
            }
        } else {
            typeOrIdent = NoWhitespaceAfterCheck.isCstyleArrayDeclaration(arrayDeclarator) ? NoWhitespaceAfterCheck.getArrayIdentifier(arrayDeclarator) : (NoWhitespaceAfterCheck.isArrayUsedAsTypeForGenericBoundedWildcard(arrayDeclarator) ? arrayDeclarator.getParent() : arrayDeclarator.getFirstChild());
        }
        return typeOrIdent;
    }

    private static DetailAST getArrayIdentifier(DetailAST arrayDeclarator) {
        return arrayDeclarator.getParent().getNextSibling();
    }

    private static boolean isMultiDimensionalArray(DetailAST arrayDeclaration) {
        return arrayDeclaration.getParent().getType() == 17 || arrayDeclaration.getFirstChild().getType() == 17;
    }

    private static boolean isArrayInstantiation(DetailAST arrayDeclaration) {
        return arrayDeclaration.getParent().getType() == 136;
    }

    private static boolean isArrayUsedAsTypeForGenericBoundedWildcard(DetailAST arrayDeclarator) {
        int firstChildType = arrayDeclarator.getFirstChild().getType();
        return firstChildType == 168 || firstChildType == 169;
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }

    private static boolean isCstyleArrayDeclaration(DetailAST arrayDeclaration) {
        boolean result = false;
        DetailAST identifier = NoWhitespaceAfterCheck.getArrayIdentifier(arrayDeclaration);
        if (identifier != null) {
            int identifierEnd;
            int arrayDeclarationStart = arrayDeclaration.getColumnNo();
            result = arrayDeclarationStart == (identifierEnd = identifier.getColumnNo() + identifier.getText().length()) || arrayDeclarationStart > identifierEnd;
        }
        return result;
    }

    private static boolean isCstyleMultiDimensionalArrayDeclaration(DetailAST arrayDeclaration) {
        boolean result = false;
        for (DetailAST parentArrayDeclaration = arrayDeclaration; parentArrayDeclaration != null; parentArrayDeclaration = parentArrayDeclaration.getParent()) {
            if (parentArrayDeclaration.getParent() == null || parentArrayDeclaration.getParent().getType() != 13) continue;
            result = NoWhitespaceAfterCheck.isCstyleArrayDeclaration(parentArrayDeclaration);
        }
        return result;
    }

    private boolean hasRedundantWhitespace(String line, int after) {
        boolean result = !this.allowLineBreaks;
        for (int i = after + 1; !result && i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            result = true;
        }
        return result;
    }
}

