/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.util.Iterator;
import java.util.List;
import org.javacc.jjdoc.Generator;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.parser.Action;
import org.javacc.parser.BNFProduction;
import org.javacc.parser.CharacterRange;
import org.javacc.parser.Choice;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaCodeProduction;
import org.javacc.parser.Lookahead;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.OneOrMore;
import org.javacc.parser.RCharacterList;
import org.javacc.parser.RChoice;
import org.javacc.parser.REndOfFile;
import org.javacc.parser.RJustName;
import org.javacc.parser.ROneOrMore;
import org.javacc.parser.RRepetitionRange;
import org.javacc.parser.RSequence;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RZeroOrMore;
import org.javacc.parser.RZeroOrOne;
import org.javacc.parser.RegExprSpec;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.Sequence;
import org.javacc.parser.SingleCharacter;
import org.javacc.parser.Token;
import org.javacc.parser.TokenProduction;
import org.javacc.parser.TryBlock;
import org.javacc.parser.ZeroOrMore;
import org.javacc.parser.ZeroOrOne;

public class JJDoc
extends JJDocGlobals {
    static void start() {
        generator = JJDoc.getGenerator();
        generator.documentStart();
        JJDoc.emitTokenProductions(generator, rexprlist);
        JJDoc.emitNormalProductions(generator, bnfproductions);
        generator.documentEnd();
    }

    private static Token getPrecedingSpecialToken(Token tok) {
        Token t = tok;
        while (t.specialToken != null) {
            t = t.specialToken;
        }
        return t != tok ? t : null;
    }

    private static void emitTopLevelSpecialTokens(Token tok, Generator gen) {
        if (tok == null) {
            return;
        }
        tok = JJDoc.getPrecedingSpecialToken(tok);
        String s = "";
        if (tok != null) {
            cline = tok.beginLine;
            ccol = tok.beginColumn;
            while (tok != null) {
                s = s + JJDoc.printTokenOnly(tok);
                tok = tok.next;
            }
        }
        if (!s.equals("")) {
            gen.specialTokens(s);
        }
    }

    private static void emitTokenProductions(Generator gen, List prods) {
        gen.tokensStart();
        for (TokenProduction tp : prods) {
            JJDoc.emitTopLevelSpecialTokens(tp.firstToken, gen);
            gen.handleTokenProduction(tp);
        }
        gen.tokensEnd();
    }

    public static String getStandardTokenProductionText(TokenProduction tp) {
        String token = "";
        if (tp.isExplicit) {
            if (tp.lexStates == null) {
                token = token + "<*> ";
            } else {
                token = token + "<";
                for (int i = 0; i < tp.lexStates.length; ++i) {
                    token = token + tp.lexStates[i];
                    if (i >= tp.lexStates.length - 1) continue;
                    token = token + ",";
                }
                token = token + "> ";
            }
            token = token + TokenProduction.kindImage[tp.kind];
            if (tp.ignoreCase) {
                token = token + " [IGNORE_CASE]";
            }
            token = token + " : {\n";
            Iterator it2 = tp.respecs.iterator();
            while (it2.hasNext()) {
                RegExprSpec res = (RegExprSpec)it2.next();
                token = token + JJDoc.emitRE(res.rexp);
                if (res.nsTok != null) {
                    token = token + " : " + res.nsTok.image;
                }
                token = token + "\n";
                if (!it2.hasNext()) continue;
                token = token + "| ";
            }
            token = token + "}\n\n";
        }
        return token;
    }

    private static void emitNormalProductions(Generator gen, List prods) {
        gen.nonterminalsStart();
        for (NormalProduction np : prods) {
            JJDoc.emitTopLevelSpecialTokens(np.getFirstToken(), gen);
            if (np instanceof BNFProduction) {
                gen.productionStart(np);
                if (np.getExpansion() instanceof Choice) {
                    boolean first = true;
                    Choice c = (Choice)np.getExpansion();
                    for (Expansion e : c.getChoices()) {
                        gen.expansionStart(e, first);
                        JJDoc.emitExpansionTree(e, gen);
                        gen.expansionEnd(e, first);
                        first = false;
                    }
                } else {
                    gen.expansionStart(np.getExpansion(), true);
                    JJDoc.emitExpansionTree(np.getExpansion(), gen);
                    gen.expansionEnd(np.getExpansion(), true);
                }
                gen.productionEnd(np);
                continue;
            }
            if (!(np instanceof JavaCodeProduction)) continue;
            gen.javacode((JavaCodeProduction)np);
        }
        gen.nonterminalsEnd();
    }

    private static void emitExpansionTree(Expansion exp, Generator gen) {
        if (exp instanceof Action) {
            JJDoc.emitExpansionAction((Action)exp, gen);
        } else if (exp instanceof Choice) {
            JJDoc.emitExpansionChoice((Choice)exp, gen);
        } else if (exp instanceof Lookahead) {
            JJDoc.emitExpansionLookahead((Lookahead)exp, gen);
        } else if (exp instanceof NonTerminal) {
            JJDoc.emitExpansionNonTerminal((NonTerminal)exp, gen);
        } else if (exp instanceof OneOrMore) {
            JJDoc.emitExpansionOneOrMore((OneOrMore)exp, gen);
        } else if (exp instanceof RegularExpression) {
            JJDoc.emitExpansionRegularExpression((RegularExpression)exp, gen);
        } else if (exp instanceof Sequence) {
            JJDoc.emitExpansionSequence((Sequence)exp, gen);
        } else if (exp instanceof TryBlock) {
            JJDoc.emitExpansionTryBlock((TryBlock)exp, gen);
        } else if (exp instanceof ZeroOrMore) {
            JJDoc.emitExpansionZeroOrMore((ZeroOrMore)exp, gen);
        } else if (exp instanceof ZeroOrOne) {
            JJDoc.emitExpansionZeroOrOne((ZeroOrOne)exp, gen);
        } else {
            JJDoc.error("Oops: Unknown expansion type.");
        }
    }

    private static void emitExpansionAction(Action a, Generator gen) {
    }

    private static void emitExpansionChoice(Choice c, Generator gen) {
        Iterator it = c.getChoices().iterator();
        while (it.hasNext()) {
            Expansion e = (Expansion)it.next();
            JJDoc.emitExpansionTree(e, gen);
            if (!it.hasNext()) continue;
            gen.text(" | ");
        }
    }

    private static void emitExpansionLookahead(Lookahead l, Generator gen) {
    }

    private static void emitExpansionNonTerminal(NonTerminal nt, Generator gen) {
        gen.nonTerminalStart(nt);
        gen.text(nt.getName());
        gen.nonTerminalEnd(nt);
    }

    private static void emitExpansionOneOrMore(OneOrMore o, Generator gen) {
        gen.text("( ");
        JJDoc.emitExpansionTree(o.expansion, gen);
        gen.text(" )+");
    }

    private static void emitExpansionRegularExpression(RegularExpression r, Generator gen) {
        String reRendered = JJDoc.emitRE(r);
        if (!reRendered.equals("")) {
            gen.reStart(r);
            gen.text(reRendered);
            gen.reEnd(r);
        }
    }

    private static void emitExpansionSequence(Sequence s, Generator gen) {
        boolean firstUnit = true;
        for (Expansion e : s.units) {
            boolean needParens;
            if (e instanceof Lookahead || e instanceof Action) continue;
            if (!firstUnit) {
                gen.text(" ");
            }
            boolean bl = needParens = e instanceof Choice || e instanceof Sequence;
            if (needParens) {
                gen.text("( ");
            }
            JJDoc.emitExpansionTree(e, gen);
            if (needParens) {
                gen.text(" )");
            }
            firstUnit = false;
        }
    }

    private static void emitExpansionTryBlock(TryBlock t, Generator gen) {
        boolean needParens = t.exp instanceof Choice;
        if (needParens) {
            gen.text("( ");
        }
        JJDoc.emitExpansionTree(t.exp, gen);
        if (needParens) {
            gen.text(" )");
        }
    }

    private static void emitExpansionZeroOrMore(ZeroOrMore z, Generator gen) {
        gen.text("( ");
        JJDoc.emitExpansionTree(z.expansion, gen);
        gen.text(" )*");
    }

    private static void emitExpansionZeroOrOne(ZeroOrOne z, Generator gen) {
        gen.text("( ");
        JJDoc.emitExpansionTree(z.expansion, gen);
        gen.text(" )?");
    }

    public static String emitRE(RegularExpression re) {
        boolean needBrackets;
        String returnString = "";
        boolean hasLabel = !re.label.equals("");
        boolean justName = re instanceof RJustName;
        boolean eof = re instanceof REndOfFile;
        boolean isString = re instanceof RStringLiteral;
        boolean toplevelRE = re.tpContext != null;
        boolean bl = needBrackets = justName || eof || hasLabel || !isString && toplevelRE;
        if (needBrackets) {
            returnString = returnString + "<";
            if (!justName) {
                if (re.private_rexp) {
                    returnString = returnString + "#";
                }
                if (hasLabel) {
                    returnString = returnString + re.label;
                    returnString = returnString + ": ";
                }
            }
        }
        if (re instanceof RCharacterList) {
            RCharacterList cl = (RCharacterList)re;
            if (cl.negated_list) {
                returnString = returnString + "~";
            }
            returnString = returnString + "[";
            Iterator it = cl.descriptors.iterator();
            while (it.hasNext()) {
                char[] s;
                Object o = it.next();
                if (o instanceof SingleCharacter) {
                    returnString = returnString + "\"";
                    s = new char[]{((SingleCharacter)o).ch};
                    returnString = returnString + JJDoc.add_escapes(new String(s));
                    returnString = returnString + "\"";
                } else if (o instanceof CharacterRange) {
                    returnString = returnString + "\"";
                    s = new char[]{((CharacterRange)o).getLeft()};
                    returnString = returnString + JJDoc.add_escapes(new String(s));
                    returnString = returnString + "\"-\"";
                    s[0] = ((CharacterRange)o).getRight();
                    returnString = returnString + JJDoc.add_escapes(new String(s));
                    returnString = returnString + "\"";
                } else {
                    JJDoc.error("Oops: unknown character list element type.");
                }
                if (!it.hasNext()) continue;
                returnString = returnString + ",";
            }
            returnString = returnString + "]";
        } else if (re instanceof RChoice) {
            RChoice c = (RChoice)re;
            Iterator it = c.getChoices().iterator();
            while (it.hasNext()) {
                RegularExpression sub = (RegularExpression)it.next();
                returnString = returnString + JJDoc.emitRE(sub);
                if (!it.hasNext()) continue;
                returnString = returnString + " | ";
            }
        } else if (re instanceof REndOfFile) {
            returnString = returnString + "EOF";
        } else if (re instanceof RJustName) {
            RJustName jn = (RJustName)re;
            returnString = returnString + jn.label;
        } else if (re instanceof ROneOrMore) {
            ROneOrMore om = (ROneOrMore)re;
            returnString = returnString + "(";
            returnString = returnString + JJDoc.emitRE(om.regexpr);
            returnString = returnString + ")+";
        } else if (re instanceof RSequence) {
            RSequence s = (RSequence)re;
            Iterator it = s.units.iterator();
            while (it.hasNext()) {
                RegularExpression sub = (RegularExpression)it.next();
                boolean needParens = false;
                if (sub instanceof RChoice) {
                    needParens = true;
                }
                if (needParens) {
                    returnString = returnString + "(";
                }
                returnString = returnString + JJDoc.emitRE(sub);
                if (needParens) {
                    returnString = returnString + ")";
                }
                if (!it.hasNext()) continue;
                returnString = returnString + " ";
            }
        } else if (re instanceof RStringLiteral) {
            RStringLiteral sl = (RStringLiteral)re;
            returnString = returnString + "\"" + JavaCCParserInternals.add_escapes(sl.image) + "\"";
        } else if (re instanceof RZeroOrMore) {
            RZeroOrMore zm = (RZeroOrMore)re;
            returnString = returnString + "(";
            returnString = returnString + JJDoc.emitRE(zm.regexpr);
            returnString = returnString + ")*";
        } else if (re instanceof RZeroOrOne) {
            RZeroOrOne zo = (RZeroOrOne)re;
            returnString = returnString + "(";
            returnString = returnString + JJDoc.emitRE(zo.regexpr);
            returnString = returnString + ")?";
        } else if (re instanceof RRepetitionRange) {
            RRepetitionRange zo = (RRepetitionRange)re;
            returnString = returnString + "(";
            returnString = returnString + JJDoc.emitRE(zo.regexpr);
            returnString = returnString + ")";
            returnString = returnString + "{";
            if (zo.hasMax) {
                returnString = returnString + zo.min;
                returnString = returnString + ",";
                returnString = returnString + zo.max;
            } else {
                returnString = returnString + zo.min;
            }
            returnString = returnString + "}";
        } else {
            JJDoc.error("Oops: Unknown regular expression type.");
        }
        if (needBrackets) {
            returnString = returnString + ">";
        }
        return returnString;
    }
}

