/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.ASTBNFDeclaration;
import org.javacc.jjtree.ASTBNFNodeScope;
import org.javacc.jjtree.ASTExpansionNodeScope;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.ASTProduction;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.Node;

public class NodeScope {
    ASTProduction production;
    ASTNodeDescriptor node_descriptor;
    String closedVar;
    String exceptionVar;
    String nodeVar;
    int scopeNumber;

    NodeScope(ASTProduction p, ASTNodeDescriptor n) {
        this.production = p;
        if (n == null) {
            String nm = this.production.name;
            if (JJTreeOptions.getNodeDefaultVoid()) {
                nm = "void";
            }
            this.node_descriptor = ASTNodeDescriptor.indefinite(nm);
        } else {
            this.node_descriptor = n;
        }
        this.scopeNumber = this.production.getNodeScopeNumber(this);
        this.nodeVar = this.constructVariable("n");
        this.closedVar = this.constructVariable("c");
        this.exceptionVar = this.constructVariable("e");
    }

    boolean isVoid() {
        return this.node_descriptor.isVoid();
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.nodeVar;
    }

    private String constructVariable(String id) {
        String s = "000" + this.scopeNumber;
        return "jjt" + id + s.substring(s.length() - 3, s.length());
    }

    boolean usesCloseNodeVar() {
        return true;
    }

    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).node_scope;
        }
        for (Node n = node.jjtGetParent(); n != null; n = n.jjtGetParent()) {
            if (n instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)n).node_scope;
            }
            if (n instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)n).node_scope;
            }
            if (!(n instanceof ASTExpansionNodeScope)) continue;
            return ((ASTExpansionNodeScope)n).node_scope;
        }
        return null;
    }
}

