/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.util.Iterator;
import org.javacc.parser.Choice;
import org.javacc.parser.Expansion;
import org.javacc.parser.Lookahead;
import org.javacc.parser.OneOrMore;
import org.javacc.parser.RChoice;
import org.javacc.parser.ROneOrMore;
import org.javacc.parser.RRepetitionRange;
import org.javacc.parser.RSequence;
import org.javacc.parser.RZeroOrMore;
import org.javacc.parser.RZeroOrOne;
import org.javacc.parser.Sequence;
import org.javacc.parser.TreeWalkerOp;
import org.javacc.parser.TryBlock;
import org.javacc.parser.ZeroOrMore;
import org.javacc.parser.ZeroOrOne;

public final class ExpansionTreeWalker {
    private ExpansionTreeWalker() {
    }

    static void preOrderWalk(Expansion node, TreeWalkerOp opObj) {
        opObj.action(node);
        if (opObj.goDeeper(node)) {
            if (node instanceof Choice) {
                Iterator it = ((Choice)node).getChoices().iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.preOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof Sequence) {
                Iterator it = ((Sequence)node).units.iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.preOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof OneOrMore) {
                ExpansionTreeWalker.preOrderWalk(((OneOrMore)node).expansion, opObj);
            } else if (node instanceof ZeroOrMore) {
                ExpansionTreeWalker.preOrderWalk(((ZeroOrMore)node).expansion, opObj);
            } else if (node instanceof ZeroOrOne) {
                ExpansionTreeWalker.preOrderWalk(((ZeroOrOne)node).expansion, opObj);
            } else if (node instanceof Lookahead) {
                Expansion nested_e = ((Lookahead)node).getLaExpansion();
                if (!(nested_e instanceof Sequence) || (Expansion)((Sequence)nested_e).units.get(0) != node) {
                    ExpansionTreeWalker.preOrderWalk(nested_e, opObj);
                }
            } else if (node instanceof TryBlock) {
                ExpansionTreeWalker.preOrderWalk(((TryBlock)node).exp, opObj);
            } else if (node instanceof RChoice) {
                Iterator it = ((RChoice)node).getChoices().iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.preOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof RSequence) {
                Iterator it = ((RSequence)node).units.iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.preOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof ROneOrMore) {
                ExpansionTreeWalker.preOrderWalk(((ROneOrMore)node).regexpr, opObj);
            } else if (node instanceof RZeroOrMore) {
                ExpansionTreeWalker.preOrderWalk(((RZeroOrMore)node).regexpr, opObj);
            } else if (node instanceof RZeroOrOne) {
                ExpansionTreeWalker.preOrderWalk(((RZeroOrOne)node).regexpr, opObj);
            } else if (node instanceof RRepetitionRange) {
                ExpansionTreeWalker.preOrderWalk(((RRepetitionRange)node).regexpr, opObj);
            }
        }
    }

    static void postOrderWalk(Expansion node, TreeWalkerOp opObj) {
        if (opObj.goDeeper(node)) {
            if (node instanceof Choice) {
                Iterator it = ((Choice)node).getChoices().iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.postOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof Sequence) {
                Iterator it = ((Sequence)node).units.iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.postOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof OneOrMore) {
                ExpansionTreeWalker.postOrderWalk(((OneOrMore)node).expansion, opObj);
            } else if (node instanceof ZeroOrMore) {
                ExpansionTreeWalker.postOrderWalk(((ZeroOrMore)node).expansion, opObj);
            } else if (node instanceof ZeroOrOne) {
                ExpansionTreeWalker.postOrderWalk(((ZeroOrOne)node).expansion, opObj);
            } else if (node instanceof Lookahead) {
                Expansion nested_e = ((Lookahead)node).getLaExpansion();
                if (!(nested_e instanceof Sequence) || (Expansion)((Sequence)nested_e).units.get(0) != node) {
                    ExpansionTreeWalker.postOrderWalk(nested_e, opObj);
                }
            } else if (node instanceof TryBlock) {
                ExpansionTreeWalker.postOrderWalk(((TryBlock)node).exp, opObj);
            } else if (node instanceof RChoice) {
                Iterator it = ((RChoice)node).getChoices().iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.postOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof RSequence) {
                Iterator it = ((RSequence)node).units.iterator();
                while (it.hasNext()) {
                    ExpansionTreeWalker.postOrderWalk((Expansion)it.next(), opObj);
                }
            } else if (node instanceof ROneOrMore) {
                ExpansionTreeWalker.postOrderWalk(((ROneOrMore)node).regexpr, opObj);
            } else if (node instanceof RZeroOrMore) {
                ExpansionTreeWalker.postOrderWalk(((RZeroOrMore)node).regexpr, opObj);
            } else if (node instanceof RZeroOrOne) {
                ExpansionTreeWalker.postOrderWalk(((RZeroOrOne)node).regexpr, opObj);
            } else if (node instanceof RRepetitionRange) {
                ExpansionTreeWalker.postOrderWalk(((RRepetitionRange)node).regexpr, opObj);
            }
        }
        opObj.action(node);
    }
}

