/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.blocks.LeftCurlyOption;

public class LeftCurlyCheck
extends AbstractOptionCheck<LeftCurlyOption> {
    public static final String MSG_KEY_LINE_NEW = "line.new";
    public static final String MSG_KEY_LINE_PREVIOUS = "line.previous";
    public static final String MSG_KEY_LINE_BREAK_AFTER = "line.break.after";
    private static final int DEFAULT_MAX_LINE_LENGTH = 80;
    private int maxLineLength = 80;
    private boolean ignoreEnums = true;

    public LeftCurlyCheck() {
        super(LeftCurlyOption.EOL, LeftCurlyOption.class);
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 157, 154, 8, 9, 155, 84, 95, 96, 97, 67, 89, 85, 83, 92, 91, 12};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 157, 154, 8, 9, 155, 84, 95, 96, 97, 67, 89, 85, 83, 92, 91, 12};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST brace;
        DetailAST startToken;
        switch (ast.getType()) {
            case 8: 
            case 9: {
                startToken = this.skipAnnotationOnlyLines(ast);
                brace = ast.findFirstToken(7);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 155: 
            case 157: {
                startToken = this.skipAnnotationOnlyLines(ast);
                DetailAST objBlock = ast.findFirstToken(6);
                brace = objBlock == null ? null : objBlock.getFirstChild();
                break;
            }
            case 12: 
            case 67: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 95: 
            case 96: 
            case 97: {
                startToken = ast;
                brace = ast.findFirstToken(7);
                break;
            }
            case 92: {
                startToken = ast;
                DetailAST candidate = ast.getFirstChild();
                brace = candidate.getType() == 7 ? candidate : null;
                break;
            }
            case 89: {
                startToken = ast;
                brace = ast.findFirstToken(72);
                break;
            }
            default: {
                startToken = null;
                brace = null;
            }
        }
        if (brace != null && startToken != null) {
            this.verifyBrace(brace, startToken);
        }
    }

    private DetailAST skipAnnotationOnlyLines(DetailAST ast) {
        DetailAST tokenAfterLast;
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers == null) {
            return ast;
        }
        DetailAST lastAnnot = this.findLastAnnotation(modifiers);
        if (lastAnnot == null) {
            return ast;
        }
        DetailAST detailAST = tokenAfterLast = lastAnnot.getNextSibling() != null ? lastAnnot.getNextSibling() : modifiers.getNextSibling();
        if (tokenAfterLast.getLineNo() > lastAnnot.getLineNo()) {
            return tokenAfterLast;
        }
        int lastAnnotLineNumber = lastAnnot.getLineNo();
        while (lastAnnot.getPreviousSibling() != null && lastAnnot.getPreviousSibling().getLineNo() == lastAnnotLineNumber) {
            lastAnnot = lastAnnot.getPreviousSibling();
        }
        return lastAnnot;
    }

    private DetailAST findLastAnnotation(DetailAST modifiers) {
        DetailAST annot;
        for (annot = modifiers.findFirstToken(159); annot != null && annot.getNextSibling() != null && annot.getNextSibling().getType() == 159; annot = annot.getNextSibling()) {
        }
        return annot;
    }

    private void verifyBrace(DetailAST brace, DetailAST startToken) {
        int prevLineLen;
        String braceLine = this.getLine(brace.getLineNo() - 1);
        int n = prevLineLen = brace.getLineNo() == 1 ? this.maxLineLength : Utils.lengthMinusTrailingWhitespace(this.getLine(brace.getLineNo() - 2));
        if (braceLine.length() <= brace.getColumnNo() + 1 || braceLine.charAt(brace.getColumnNo() + 1) != '}') {
            if (this.getAbstractOption() == LeftCurlyOption.NL) {
                if (!Utils.whitespaceBefore(brace.getColumnNo(), braceLine)) {
                    this.log(brace.getLineNo(), brace.getColumnNo(), MSG_KEY_LINE_NEW, "{");
                }
            } else if (this.getAbstractOption() == LeftCurlyOption.EOL) {
                if (Utils.whitespaceBefore(brace.getColumnNo(), braceLine) && prevLineLen + 2 <= this.maxLineLength) {
                    this.log(brace.getLineNo(), brace.getColumnNo(), MSG_KEY_LINE_PREVIOUS, "{");
                }
                if (!this.hasLineBreakAfter(brace)) {
                    this.log(brace.getLineNo(), brace.getColumnNo(), MSG_KEY_LINE_BREAK_AFTER, new Object[0]);
                }
            } else if (this.getAbstractOption() == LeftCurlyOption.NLOW && startToken.getLineNo() != brace.getLineNo()) {
                if (startToken.getLineNo() + 1 == brace.getLineNo()) {
                    if (!Utils.whitespaceBefore(brace.getColumnNo(), braceLine)) {
                        this.log(brace.getLineNo(), brace.getColumnNo(), MSG_KEY_LINE_NEW, "{");
                    } else if (prevLineLen + 2 <= this.maxLineLength) {
                        this.log(brace.getLineNo(), brace.getColumnNo(), MSG_KEY_LINE_PREVIOUS, "{");
                    }
                } else if (!Utils.whitespaceBefore(brace.getColumnNo(), braceLine)) {
                    this.log(brace.getLineNo(), brace.getColumnNo(), MSG_KEY_LINE_NEW, "{");
                }
            }
        }
    }

    private boolean hasLineBreakAfter(DetailAST leftCurly) {
        DetailAST nextToken = null;
        if (leftCurly.getType() == 7) {
            nextToken = leftCurly.getFirstChild();
        } else if (leftCurly.getParent().getParent().getType() == 154 && !this.ignoreEnums) {
            nextToken = leftCurly.getNextSibling();
        }
        return nextToken == null || nextToken.getType() == 73 || leftCurly.getLineNo() != nextToken.getLineNo();
    }
}

