/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.asm.shaded.ClassReader;
import org.codehaus.mojo.animal_sniffer.asm.shaded.ClassVisitor;
import org.codehaus.mojo.animal_sniffer.asm.shaded.FieldVisitor;
import org.codehaus.mojo.animal_sniffer.asm.shaded.MethodVisitor;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;

public class SignatureBuilder
extends ClassFileVisitor {
    private boolean foundSome;
    private final Logger logger;
    private List<Pattern> includeClasses;
    private List<Pattern> excludeClasses;
    private final Map<String, Clazz> classes = new TreeMap<String, Clazz>();
    private final ObjectOutputStream oos;

    public static void main(String[] args) throws IOException {
        SignatureBuilder builder = new SignatureBuilder(new FileOutputStream("signature"), new PrintWriterLogger(System.out));
        builder.process(new File(System.getProperty("java.home"), "lib/rt.jar"));
        builder.close();
    }

    public SignatureBuilder(OutputStream out, Logger logger) throws IOException {
        this(null, out, logger);
    }

    public void addInclude(String className) {
        if (this.includeClasses == null) {
            this.includeClasses = new ArrayList<Pattern>();
        }
        this.includeClasses.add(RegexUtils.compileWildcard(className));
    }

    public void addExclude(String className) {
        if (this.excludeClasses == null) {
            this.excludeClasses = new ArrayList<Pattern>();
        }
        this.excludeClasses.add(RegexUtils.compileWildcard(className));
    }

    public SignatureBuilder(InputStream[] in, OutputStream out, Logger logger) throws IOException {
        this.logger = logger;
        if (in != null) {
            block5: for (int i = 0; i < in.length; ++i) {
                ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(in[i]));
                try {
                    while (true) {
                        Clazz c;
                        if ((c = (Clazz)ois.readObject()) == null) {
                            continue block5;
                        }
                        this.classes.put(c.getName(), c);
                    }
                }
                catch (ClassNotFoundException e) {
                    IOException ioException = new IOException("Could not read base signatures");
                    ioException.initCause(e);
                    throw ioException;
                }
                finally {
                    ois.close();
                }
            }
        }
        this.oos = new ObjectOutputStream(new GZIPOutputStream(out));
    }

    public void close() throws IOException {
        int count = 0;
        for (Map.Entry<String, Clazz> entry : this.classes.entrySet()) {
            String className = entry.getKey().replace('/', '.');
            if (this.includeClasses != null) {
                boolean included = false;
                for (Pattern p : this.includeClasses) {
                    included = p.matcher(className).matches();
                }
                if (!included) continue;
            }
            if (this.excludeClasses != null) {
                boolean excluded = false;
                for (Pattern p : this.excludeClasses) {
                    excluded = p.matcher(className).matches();
                }
                if (excluded) continue;
            }
            ++count;
            this.logger.debug(className);
            this.oos.writeObject(entry.getValue());
        }
        this.oos.writeObject(null);
        this.logger.info("Wrote signatures for " + count + " classes.");
        this.oos.close();
        if (!this.foundSome) {
            throw new IOException("No index is written");
        }
    }

    protected void process(String name, InputStream image) throws IOException {
        this.logger.debug(name);
        this.foundSome = true;
        ClassReader cr = new ClassReader(image);
        SignatureVisitor v = new SignatureVisitor();
        cr.accept(v, 0);
        v.end();
    }

    private class SignatureVisitor
    extends ClassVisitor {
        private Clazz clazz;

        public SignatureVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.clazz = new Clazz(name, new HashSet<String>(), superName, interfaces);
        }

        public void end() throws IOException {
            Clazz cur = (Clazz)SignatureBuilder.this.classes.get(this.clazz.getName());
            if (cur == null) {
                SignatureBuilder.this.classes.put(this.clazz.getName(), this.clazz);
            } else {
                SignatureBuilder.this.classes.put(this.clazz.getName(), new Clazz(this.clazz, cur));
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.clazz.getSignatures().add(name + desc);
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.clazz.getSignatures().add(name + "#" + desc);
            return null;
        }
    }
}

