/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BadResultSetAccess
extends OpcodeStackDetector {
    @StaticConstant
    private static final Set<String> dbFieldTypesSet = new HashSet<String>(){
        static final long serialVersionUID = -3510636899394546735L;
        {
            this.add("Array");
            this.add("AsciiStream");
            this.add("BigDecimal");
            this.add("BinaryStream");
            this.add("Blob");
            this.add("Boolean");
            this.add("Byte");
            this.add("Bytes");
            this.add("CharacterStream");
            this.add("Clob");
            this.add("Date");
            this.add("Double");
            this.add("Float");
            this.add("Int");
            this.add("Long");
            this.add("Object");
            this.add("Ref");
            this.add("RowId");
            this.add("Short");
            this.add("String");
            this.add("Time");
            this.add("Timestamp");
            this.add("UnicodeStream");
            this.add("URL");
        }
    };
    private final BugReporter bugReporter;

    public BadResultSetAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (BadResultSetAccess.hasInterestingClass(classContext.getJavaClass().getConstantPool(), Collections.singleton("java/sql/ResultSet"))) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 185) {
            String methodName = this.getNameConstantOperand();
            String clsConstant = this.getClassConstantOperand();
            if ("java/sql/ResultSet".equals(clsConstant) && (methodName.startsWith("get") && dbFieldTypesSet.contains(methodName.substring(3)) || methodName.startsWith("update") && dbFieldTypesSet.contains(methodName.substring(6))) || "java/sql/PreparedStatement".equals(clsConstant) && methodName.startsWith("set") && dbFieldTypesSet.contains(methodName.substring(3))) {
                OpcodeStack.Item item;
                String signature = this.getSigConstantOperand();
                int numParms = PreorderVisitor.getNumberArguments(signature);
                if (this.stack.getStackDepth() >= numParms && "I".equals((item = this.stack.getStackItem(numParms - 1)).getSignature()) && item.couldBeZero()) {
                    this.bugReporter.reportBug(new BugInstance(this, "java/sql/PreparedStatement".equals(clsConstant) ? "SQL_BAD_PREPARED_STATEMENT_ACCESS" : "SQL_BAD_RESULTSET_ACCESS", item.mustBeZero() ? 1 : 2).addClassAndMethod(this).addSourceLine(this));
                }
            }
        }
    }
}

