/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.UnresolvedXField;
import edu.umd.cs.findbugs.ba.UnresolvedXMethod;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntryType;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.FieldInfo;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.detect.BuildObligationPolicyDatabase;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.SplitCamelCaseIdentifier;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class XFactory {
    public static final boolean DEBUG_UNRESOLVED = SystemProperties.getBoolean("findbugs.xfactory.debugunresolved");
    private final Set<ClassDescriptor> reflectiveClasses = new HashSet<ClassDescriptor>();
    private final Map<MethodDescriptor, XMethod> methods = new HashMap<MethodDescriptor, XMethod>();
    private final Map<FieldDescriptor, XField> fields = new HashMap<FieldDescriptor, XField>();
    private final Set<XMethod> calledMethods = new HashSet<XMethod>();
    private final Set<XField> emptyArrays = new HashSet<XField>();
    private final Set<String> calledMethodSignatures = new HashSet<String>();
    private final Set<MethodDescriptor> functionsThatMightBeMistakenForProcedures = new HashSet<MethodDescriptor>();
    public static final boolean DEBUG_CIRCULARITY = SystemProperties.getBoolean("circularity.debug");

    public void canonicalizeAll() {
        DescriptorFactory descriptorFactory = DescriptorFactory.instance();
        for (XMethod m : this.methods.values()) {
            if (!(m instanceof MethodDescriptor)) continue;
            descriptorFactory.canonicalize((MethodDescriptor)((Object)m));
        }
        for (XField f : this.fields.values()) {
            if (!(f instanceof FieldDescriptor)) continue;
            descriptorFactory.canonicalize((FieldDescriptor)((Object)f));
        }
    }

    public void intern(XClass c) {
        for (XMethod xMethod : c.getXMethods()) {
            MethodInfo mi = (MethodInfo)xMethod;
            this.methods.put(mi, mi);
        }
        for (XField xField : c.getXFields()) {
            FieldInfo fi = (FieldInfo)xField;
            this.fields.put(fi, fi);
        }
    }

    public Collection<XField> allFields() {
        return this.fields.values();
    }

    public void addCalledMethod(MethodDescriptor m) {
        assert (m.getClassDescriptor().getClassName().indexOf(46) == -1);
        this.calledMethods.add(XFactory.createXMethod(m));
    }

    public void addEmptyArrayField(XField f) {
        this.emptyArrays.add(f);
    }

    public boolean isEmptyArrayField(@CheckForNull XField f) {
        return this.emptyArrays.contains(f);
    }

    public boolean isCalled(XMethod m) {
        if ("<clinit>".equals(m.getName())) {
            return true;
        }
        return this.calledMethods.contains(m);
    }

    public Set<XMethod> getCalledMethods() {
        return this.calledMethods;
    }

    public void addFunctionThatMightBeMistakenForProcedures(MethodDescriptor m) {
        this.functionsThatMightBeMistakenForProcedures.add(m);
    }

    public boolean isFunctionshatMightBeMistakenForProcedures(MethodDescriptor m) {
        return this.functionsThatMightBeMistakenForProcedures.contains(m);
    }

    public Set<ClassDescriptor> getReflectiveClasses() {
        return this.reflectiveClasses;
    }

    public boolean isReflectiveClass(ClassDescriptor c) {
        return this.reflectiveClasses.contains(c);
    }

    public boolean addReflectiveClasses(ClassDescriptor c) {
        return this.reflectiveClasses.add(c);
    }

    public boolean isCalledDirectlyOrIndirectly(XMethod m) {
        if (this.isCalled(m)) {
            return true;
        }
        if (m.isStatic() || m.isPrivate() || "<init>".equals(m.getName())) {
            return false;
        }
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            XClass clazz = analysisCache.getClassAnalysis(XClass.class, m.getClassDescriptor());
            if (this.isCalledDirectlyOrIndirectly(clazz.getSuperclassDescriptor(), m)) {
                return true;
            }
            for (ClassDescriptor i : clazz.getInterfaceDescriptorList()) {
                if (!this.isCalledDirectlyOrIndirectly(i, m)) continue;
                return true;
            }
            return false;
        }
        catch (edu.umd.cs.findbugs.classfile.MissingClassException e) {
            return false;
        }
        catch (MissingClassException e) {
            AnalysisContext.reportMissingClass(e.getClassNotFoundException());
            return false;
        }
        catch (Exception e) {
            AnalysisContext.logError("Error checking to see if " + m + " is called (" + e.getClass().getCanonicalName() + ")", e);
            return false;
        }
    }

    private boolean isCalledDirectlyOrIndirectly(@CheckForNull ClassDescriptor clazzDescriptor, XMethod m) throws CheckedAnalysisException {
        if (clazzDescriptor == null) {
            return false;
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        XClass clazz = analysisCache.getClassAnalysis(XClass.class, clazzDescriptor);
        XMethod m2 = clazz.findMethod(m.getName(), m.getSignature(), m.isStatic());
        if (m2 != null && this.isCalled(m2)) {
            return true;
        }
        if (this.isCalledDirectlyOrIndirectly(clazz.getSuperclassDescriptor(), m)) {
            return true;
        }
        for (ClassDescriptor i : clazz.getInterfaceDescriptorList()) {
            if (!this.isCalledDirectlyOrIndirectly(i, m)) continue;
            return true;
        }
        return false;
    }

    public boolean nameAndSignatureIsCalled(XMethod m) {
        return this.calledMethodSignatures.contains(XFactory.getDetailedSignature(m));
    }

    private static String getDetailedSignature(XMethod m2) {
        return m2.getName() + m2.getSignature() + m2.isStatic();
    }

    @Deprecated
    public boolean isInterned(XMethod m) {
        return m.isResolved();
    }

    public static String canonicalizeString(String s) {
        return DescriptorFactory.canonicalizeString(s);
    }

    public static XMethod createXMethod(String className, Method method) {
        String methodName = method.getName();
        String methodSig = method.getSignature();
        int accessFlags = method.getAccessFlags();
        return XFactory.createXMethod(className, methodName, methodSig, accessFlags);
    }

    private static XMethod createXMethod(@DottedClassName String className, String methodName, String methodSig, int accessFlags) {
        return XFactory.createXMethod(className, methodName, methodSig, (accessFlags & 8) != 0);
    }

    public static XMethod createXMethod(JavaClass javaClass, Method method) {
        if (method == null) {
            throw new NullPointerException("method must not be null");
        }
        XMethod xmethod = XFactory.createXMethod(javaClass.getClassName(), method);
        assert (xmethod.isResolved());
        return xmethod;
    }

    public static void assertDottedClassName(@DottedClassName String className) {
        assert (className.indexOf(47) == -1);
    }

    public static void assertSlashedClassName(@SlashedClassName String className) {
        assert (className.indexOf(46) == -1);
    }

    public static XMethod createXMethodUsingSlashedClassName(@SlashedClassName String className, String methodName, String methodSig, boolean isStatic) {
        XFactory.assertSlashedClassName(className);
        MethodDescriptor desc = DescriptorFactory.instance().getMethodDescriptor(className, methodName, methodSig, isStatic);
        return XFactory.createXMethod(desc);
    }

    public static XMethod createXMethod(@DottedClassName String className, String methodName, String methodSig, boolean isStatic) {
        XFactory.assertDottedClassName(className);
        MethodDescriptor desc = DescriptorFactory.instance().getMethodDescriptor(ClassName.toSlashedClassName(className), methodName, methodSig, isStatic);
        return XFactory.createXMethod(desc);
    }

    public static XMethod createXMethod(MethodDescriptor desc) {
        XFactory xFactory = AnalysisContext.currentXFactory();
        XMethod m = xFactory.methods.get(desc);
        if (m != null) {
            return m;
        }
        m = xFactory.resolveXMethod(desc);
        if (m instanceof MethodDescriptor) {
            xFactory.methods.put((MethodDescriptor)((Object)m), m);
            DescriptorFactory.instance().canonicalize((MethodDescriptor)((Object)m));
        } else {
            xFactory.methods.put(desc, m);
        }
        return m;
    }

    public static void profile() {
        XFactory xFactory = AnalysisContext.currentXFactory();
        int count = 0;
        for (XMethod m : xFactory.methods.values()) {
            if (!(m instanceof MethodInfo)) continue;
            ++count;
        }
        System.out.printf("XFactory cached methods: %d/%d%n", count, xFactory.methods.size());
        DescriptorFactory.instance().profile();
    }

    private XMethod resolveXMethod(MethodDescriptor originalDescriptor) {
        MethodDescriptor desc = originalDescriptor;
        try {
            while (true) {
                ClassDescriptor superClass;
                XMethod m;
                if ((m = this.methods.get(desc)) != null) {
                    return m;
                }
                XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, desc.getClassDescriptor());
                if (xClass != null && (superClass = xClass.getSuperclassDescriptor()) != null) {
                    desc = DescriptorFactory.instance().getMethodDescriptor(superClass.getClassName(), desc.getName(), desc.getSignature(), desc.isStatic());
                    continue;
                }
                break;
            }
        }
        catch (CheckedAnalysisException e) {
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        UnresolvedXMethod xmethod = new UnresolvedXMethod(originalDescriptor);
        ObligationPolicyDatabase database = Global.getAnalysisCache().getOptionalDatabase(ObligationPolicyDatabase.class);
        if (BuildObligationPolicyDatabase.INFER_CLOSE_METHODS && database != null && !xmethod.getClassName().startsWith("java")) {
            boolean methodHasCloseInName = false;
            String methodName = xmethod.getName();
            SplitCamelCaseIdentifier splitter = new SplitCamelCaseIdentifier(methodName);
            methodHasCloseInName = splitter.split().contains("close");
            Obligation[] paramObligationTypes = database.getFactory().getParameterObligationTypes(xmethod);
            for (int i = 0; i < xmethod.getNumParams(); ++i) {
                ObligationPolicyDatabaseEntry entry;
                Obligation obligationType = paramObligationTypes[i];
                if (obligationType == null) continue;
                if (methodHasCloseInName) {
                    entry = database.addParameterDeletesObligationDatabaseEntry(xmethod, obligationType, ObligationPolicyDatabaseEntryType.STRONG);
                    continue;
                }
                if (!"<init>".equals(methodName) && !methodName.startsWith("access$") && !xmethod.isStatic() && methodName.toLowerCase().indexOf("close") < 0 && xmethod.getSignature().toLowerCase().indexOf("Closeable") < 0) continue;
                entry = database.addParameterDeletesObligationDatabaseEntry(xmethod, obligationType, ObligationPolicyDatabaseEntryType.WEAK);
            }
        }
        return xmethod;
    }

    public static XMethod createXMethod(MethodAnnotation ma) {
        return XFactory.createXMethod(ma.getClassName(), ma.getMethodName(), ma.getMethodSignature(), ma.isStatic());
    }

    public static XField createXFieldUsingSlashedClassName(@SlashedClassName String className, String fieldName, String fieldSignature, boolean isStatic) {
        FieldDescriptor fieldDesc = DescriptorFactory.instance().getFieldDescriptor(className, fieldName, fieldSignature, isStatic);
        return XFactory.createXField(fieldDesc);
    }

    public static XField createXField(@DottedClassName String className, String fieldName, String fieldSignature, boolean isStatic) {
        FieldDescriptor fieldDesc = DescriptorFactory.instance().getFieldDescriptor(ClassName.toSlashedClassName(className), fieldName, fieldSignature, isStatic);
        return XFactory.createXField(fieldDesc);
    }

    public static XField createXField(FieldInstruction fieldInstruction, ConstantPoolGen cpg) {
        String className = fieldInstruction.getClassName(cpg);
        String fieldName = fieldInstruction.getName(cpg);
        String fieldSig = fieldInstruction.getSignature(cpg);
        short opcode = fieldInstruction.getOpcode();
        return XFactory.createXField(className, fieldName, fieldSig, opcode == 178 || opcode == 179);
    }

    public static XField createReferencedXField(DismantleBytecode visitor) {
        int seen = visitor.getOpcode();
        if (seen != 180 && seen != 178 && seen != 181 && seen != 179) {
            throw new IllegalArgumentException("Not at a field reference");
        }
        return XFactory.createXFieldUsingSlashedClassName(visitor.getClassConstantOperand(), visitor.getNameConstantOperand(), visitor.getSigConstantOperand(), visitor.getRefFieldIsStatic());
    }

    public static XMethod createReferencedXMethod(DismantleBytecode visitor) {
        XMethod m = XFactory.createXMethodUsingSlashedClassName(visitor.getClassConstantOperand(), visitor.getNameConstantOperand(), visitor.getSigConstantOperand(), visitor.getOpcode() == 184);
        return m.resolveAccessMethodForMethod();
    }

    public static XField createXField(FieldAnnotation f) {
        return XFactory.createXField(f.getClassName(), f.getFieldName(), f.getFieldSignature(), f.isStatic());
    }

    public static XField createXField(JavaClass javaClass, Field field) {
        return XFactory.createXField(javaClass.getClassName(), field);
    }

    public static XField createXField(String className, Field field) {
        String fieldName = field.getName();
        String fieldSig = field.getSignature();
        XField xfield = XFactory.getExactXField(className, fieldName, fieldSig, field.isStatic());
        assert (xfield.isResolved()) : "Could not exactly resolve " + xfield;
        return xfield;
    }

    public static XField getExactXField(@SlashedClassName String className, String name, String signature, boolean isStatic) {
        FieldDescriptor fieldDesc = DescriptorFactory.instance().getFieldDescriptor(ClassName.toSlashedClassName(className), name, signature, isStatic);
        return XFactory.getExactXField(fieldDesc);
    }

    @Nonnull
    public static XField getExactXField(@SlashedClassName String className, Field f) {
        FieldDescriptor fd = DescriptorFactory.instance().getFieldDescriptor(className, f);
        return XFactory.getExactXField(fd);
    }

    @Nonnull
    public static XField getExactXField(FieldDescriptor desc) {
        XFactory xFactory = AnalysisContext.currentXFactory();
        XField f = xFactory.fields.get(desc);
        if (f == null) {
            return new UnresolvedXField(desc);
        }
        return f;
    }

    public static XField createXField(FieldDescriptor desc) {
        XFactory xFactory = AnalysisContext.currentXFactory();
        XField m = xFactory.fields.get(desc);
        if (m != null) {
            return m;
        }
        m = xFactory.resolveXField(desc);
        xFactory.fields.put(desc, m);
        return m;
    }

    private XField resolveXField(FieldDescriptor originalDescriptor) {
        FieldDescriptor desc = originalDescriptor;
        LinkedList<ClassDescriptor> worklist = new LinkedList<ClassDescriptor>();
        ClassDescriptor originalClassDescriptor = desc.getClassDescriptor();
        worklist.add(originalClassDescriptor);
        try {
            while (!worklist.isEmpty()) {
                XField f;
                ClassDescriptor d = (ClassDescriptor)worklist.removeFirst();
                if (!d.equals(originalClassDescriptor)) {
                    desc = DescriptorFactory.instance().getFieldDescriptor(d.getClassName(), desc.getName(), desc.getSignature(), desc.isStatic());
                }
                if ((f = this.fields.get(desc)) != null) {
                    return f;
                }
                XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, d);
                if (xClass != null) {
                    ClassDescriptor superClass = xClass.getSuperclassDescriptor();
                    if (superClass != null) {
                        worklist.add(superClass);
                    }
                    if (!originalDescriptor.isStatic()) continue;
                    for (ClassDescriptor i : xClass.getInterfaceDescriptorList()) {
                        worklist.add(i);
                    }
                    continue;
                }
                break;
            }
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error resolving " + originalDescriptor, e);
        }
        return new UnresolvedXField(originalDescriptor);
    }

    public static XMethod createXMethod(InvokeInstruction invokeInstruction, ConstantPoolGen cpg) {
        String className = invokeInstruction.getClassName(cpg);
        String methodName = invokeInstruction.getName(cpg);
        String methodSig = invokeInstruction.getSignature(cpg);
        return XFactory.createXMethod(className, methodName, methodSig, invokeInstruction.getOpcode() == 184);
    }

    public static XMethod createXMethod(PreorderVisitor visitor) {
        JavaClass javaClass = visitor.getThisClass();
        Method method = visitor.getMethod();
        XMethod m = XFactory.createXMethod(javaClass, method);
        return m;
    }

    public static XField createXField(PreorderVisitor visitor) {
        JavaClass javaClass = visitor.getThisClass();
        Field field = visitor.getField();
        XField f = XFactory.createXField(javaClass, field);
        return f;
    }

    public static XMethod createXMethod(MethodGen methodGen) {
        String className = methodGen.getClassName();
        String methodName = methodGen.getName();
        String methodSig = methodGen.getSignature();
        int accessFlags = methodGen.getAccessFlags();
        return XFactory.createXMethod(className, methodName, methodSig, accessFlags);
    }

    public static XMethod createXMethod(JavaClassAndMethod classAndMethod) {
        return XFactory.createXMethod(classAndMethod.getJavaClass(), classAndMethod.getMethod());
    }

    @CheckForNull
    public XClass getXClass(ClassDescriptor classDescriptor) {
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            return analysisCache.getClassAnalysis(XClass.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    public static <E extends ClassMember> int compare(E lhs, E rhs) {
        int cmp = lhs.getClassName().compareTo(rhs.getClassName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.getName().compareTo(rhs.getName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.getSignature().compareTo(rhs.getSignature());
        if (cmp != 0) {
            return cmp;
        }
        return (lhs.isStatic() ? 1 : 0) - (rhs.isStatic() ? 1 : 0);
    }
}

