/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.InstructionScanner;
import edu.umd.cs.findbugs.InstructionScannerGenerator;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Edge;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.generic.InstructionHandle;

public class InstructionScannerDriver {
    private final Iterator<Edge> edgeIter;
    private final LinkedList<InstructionScanner> scannerList;
    private static final boolean DEBUG = SystemProperties.getBoolean("isd.debug");

    public InstructionScannerDriver(Iterator<Edge> edgeIter) {
        this.edgeIter = edgeIter;
        this.scannerList = new LinkedList();
    }

    public void execute(InstructionScannerGenerator generator) {
        while (this.edgeIter.hasNext()) {
            Edge edge = this.edgeIter.next();
            BasicBlock source = (BasicBlock)edge.getSource();
            if (DEBUG) {
                System.out.println("ISD: scanning instructions in block " + source.getLabel());
            }
            BasicBlock.InstructionIterator i = source.instructionIterator();
            int count = 0;
            while (i.hasNext()) {
                InstructionHandle handle = (InstructionHandle)i.next();
                if (generator.start(handle)) {
                    this.scannerList.add(generator.createScanner());
                }
                for (InstructionScanner scanner : this.scannerList) {
                    scanner.scanInstruction(handle);
                }
                ++count;
            }
            if (DEBUG) {
                System.out.println("ISD: scanned " + count + " instructions");
            }
            for (InstructionScanner scanner : this.scannerList) {
                scanner.traverseEdge(edge);
            }
        }
    }
}

