/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class CallToUnsupportedMethod
implements Detector {
    BugReporter bugReporter;

    public CallToUnsupportedMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            String msg;
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException e) {
            }
            catch (CFGBuilderException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
            catch (DataflowAnalysisException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws MethodUnprofitableException, CFGBuilderException, DataflowAnalysisException {
        if (BCELUtil.isSynthetic((FieldOrMethod)method) || (method.getAccessFlags() & 0x40) == 64) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen constantPoolGen = classContext.getConstantPoolGen();
        Iterator<Location> iter = cfg.locationIterator();
        block4: while (iter.hasNext()) {
            Set<XMethod> targets;
            String methodSig;
            Location location = iter.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction) || ins instanceof INVOKEINTERFACE) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
            String methodName = inv.getMethodName(constantPoolGen);
            if (methodName.toLowerCase().indexOf("unsupported") >= 0 || "()Ljava/lang/UnsupportedOperationException;".equals(methodSig = inv.getSignature(constantPoolGen))) continue;
            try {
                targets = Hierarchy2.resolveMethodCallTargets(inv, frame, constantPoolGen);
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
                continue;
            }
            if (targets.isEmpty()) continue;
            int priority = targets.size() == 1 ? 1 : 2;
            for (XMethod m : targets) {
                if (!m.isUnsupported()) continue block4;
                XClass xc = AnalysisContext.currentXFactory().getXClass(m.getClassDescriptor());
                if (!(inv instanceof INVOKESTATIC || m.isFinal() || xc.isFinal())) {
                    priority = 2;
                }
                if (xc != null && !xc.isAbstract()) continue;
                try {
                    if (AnalysisContext.currentAnalysisContext().getSubtypes2().hasSubtypes(m.getClassDescriptor())) continue;
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
                continue block4;
            }
            BugInstance bug = new BugInstance(this, "DMI_UNSUPPORTED_METHOD", priority).addClassAndMethod(classContext.getJavaClass(), method).addCalledMethod(constantPoolGen, inv).addSourceLine(classContext, method, location);
            this.bugReporter.reportBug(bug);
        }
    }

    @Override
    public void report() {
    }
}

