/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.SignInCancelledException;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;

public interface Cloud {
    public CloudPlugin getPlugin();

    public String getCloudName();

    public BugCollection getBugCollection();

    public IGuiCallback getGuiCallback();

    public String getStatusMsg();

    public void printCloudSummary(PrintWriter var1, Iterable<BugInstance> var2, String[] var3);

    public void addListener(CloudListener var1);

    public void removeListener(CloudListener var1);

    public void addStatusListener(CloudStatusListener var1);

    public void removeStatusListener(CloudStatusListener var1);

    public boolean availableForInitialization();

    public boolean initialize() throws IOException;

    public boolean isInitialized();

    public void waitUntilNewIssuesUploaded();

    public boolean waitUntilNewIssuesUploaded(long var1, TimeUnit var3) throws InterruptedException;

    public void waitUntilIssueDataDownloaded();

    public boolean waitUntilIssueDataDownloaded(long var1, TimeUnit var3) throws InterruptedException;

    public boolean communicationInitiated();

    public void bugsPopulated();

    public void initiateCommunication();

    public void shutdown();

    public String getUser();

    public SigninState getSigninState();

    public void setSaveSignInInformation(boolean var1);

    public boolean isSavingSignInInformationEnabled();

    public void signIn() throws IOException;

    public void signOut();

    public Mode getMode();

    public void setMode(Mode var1);

    public boolean supportsSourceLinks();

    public boolean supportsBugLinks();

    public boolean supportsCloudReports();

    public boolean supportsClaims();

    public boolean supportsCloudSummaries();

    public Collection<String> getProjects(String var1);

    public boolean isInCloud(BugInstance var1);

    public boolean isOnlineCloud();

    public boolean getIWillFix(BugInstance var1);

    public String getSourceLinkToolTip(@CheckForNull BugInstance var1);

    public URL getSourceLink(BugInstance var1);

    public BugFilingStatus getBugLinkStatus(BugInstance var1);

    public String getBugStatus(BugInstance var1);

    public boolean getWillNotBeFixed(BugInstance var1);

    public boolean getBugIsUnassigned(BugInstance var1);

    public URL getBugLink(BugInstance var1);

    public String getBugLinkType(BugInstance var1);

    public URL fileBug(BugInstance var1);

    public void setBugLinkOnCloudAndStoreIssueDetails(BugInstance var1, String var2, String var3) throws IOException, SignInCancelledException;

    public void updateBugStatusCache(BugInstance var1, String var2);

    public void bugFiled(BugInstance var1, @CheckForNull Object var2);

    public String getCloudReport(BugInstance var1);

    public String getCloudReportWithoutMe(BugInstance var1);

    @CheckForNull
    public String claimedBy(BugInstance var1);

    public boolean claim(BugInstance var1);

    public long getUserTimestamp(BugInstance var1);

    public Date getUserDate(BugInstance var1);

    public BugDesignation getPrimaryDesignation(BugInstance var1);

    public UserDesignation getUserDesignation(BugInstance var1);

    public String getUserEvaluation(BugInstance var1);

    public double getClassificationScore(BugInstance var1);

    public double getClassificationVariance(BugInstance var1);

    public double getClassificationDisagreement(BugInstance var1);

    public double getPortionObsoleteClassifications(BugInstance var1);

    public int getNumberReviewers(BugInstance var1);

    public Set<String> getReviewers(BugInstance var1);

    public long getFirstSeen(BugInstance var1);

    public void addDateSeen(BugInstance var1, long var2);

    public UserDesignation getConsensusDesignation(BugInstance var1);

    public boolean overallClassificationIsNotAProblem(BugInstance var1);

    public boolean canStoreUserAnnotation(BugInstance var1);

    public void storeUserAnnotation(BugInstance var1);

    public static enum BugFilingStatus {
        FILE_BUG(SystemProperties.getProperty("findbugs.filebug.label", "File bug")){

            @Override
            public boolean bugIsFiled() {
                return false;
            }
        }
        ,
        FILE_AGAIN("File again"),
        BUG_PENDING("Bug pending"){

            @Override
            public boolean linkEnabled() {
                return false;
            }
        }
        ,
        VIEW_BUG(SystemProperties.getProperty("findbugs.viewbug.label", "View bug")),
        NA(""){

            @Override
            public boolean linkEnabled() {
                return false;
            }

            @Override
            public boolean bugIsFiled() {
                return false;
            }
        };

        final String displayName;

        public boolean bugIsFiled() {
            return true;
        }

        public boolean linkEnabled() {
            return true;
        }

        private BugFilingStatus(String name) {
            this.displayName = name;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum Mode {
        COMMUNAL,
        VOTING,
        SECRET;

    }

    public static enum UserDesignation {
        UNCLASSIFIED,
        NEEDS_STUDY,
        BAD_ANALYSIS,
        NOT_A_BUG,
        MOSTLY_HARMLESS,
        SHOULD_FIX,
        MUST_FIX,
        I_WILL_FIX,
        OBSOLETE_CODE;


        public int score() {
            switch (this) {
                case BAD_ANALYSIS: {
                    return -3;
                }
                case NOT_A_BUG: 
                case OBSOLETE_CODE: {
                    return -2;
                }
                case MOSTLY_HARMLESS: {
                    return -1;
                }
                case SHOULD_FIX: {
                    return 1;
                }
                case MUST_FIX: 
                case I_WILL_FIX: {
                    return 2;
                }
            }
            return 0;
        }

        public boolean nonVoting() {
            return this == OBSOLETE_CODE || this == NEEDS_STUDY || this == UNCLASSIFIED;
        }

        public boolean notAProblem() {
            return this.score() < 0;
        }

        public boolean shouldFix() {
            return this.score() > 0;
        }
    }

    public static enum SigninState {
        NO_SIGNIN_REQUIRED,
        UNAUTHENTICATED,
        SIGNING_IN,
        SIGNED_IN,
        SIGNIN_FAILED,
        SIGNIN_DECLINED,
        SIGNED_OUT,
        DISCONNECTED;

        @StaticConstant
        static final ResourceBundle names;

        public boolean canDownload() {
            switch (this) {
                case NO_SIGNIN_REQUIRED: 
                case SIGNING_IN: 
                case SIGNED_IN: 
                case UNAUTHENTICATED: {
                    return true;
                }
            }
            return false;
        }

        public boolean canUpload() {
            switch (this) {
                case NO_SIGNIN_REQUIRED: 
                case SIGNING_IN: 
                case SIGNED_IN: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldAskToSignIn() {
            switch (this) {
                case UNAUTHENTICATED: 
                case SIGNED_OUT: 
                case SIGNIN_FAILED: {
                    return true;
                }
            }
            return false;
        }

        public boolean couldSignIn() {
            switch (this) {
                case UNAUTHENTICATED: 
                case SIGNED_OUT: 
                case SIGNIN_FAILED: 
                case DISCONNECTED: 
                case SIGNIN_DECLINED: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            try {
                return names.getString(this.name()).trim();
            }
            catch (MissingResourceException e) {
                return this.name();
            }
        }

        static {
            names = ResourceBundle.getBundle(Cloud.class.getName(), Locale.getDefault());
        }
    }

    public static interface CloudTaskListener {
        public void taskStatusUpdated(String var1, double var2);

        public void taskFinished();

        public void taskFailed(String var1);
    }

    public static interface CloudTask {
        public String getName();

        public String getStatusLine();

        public double getPercentCompleted();

        public void addListener(CloudTaskListener var1);

        public void removeListener(CloudTaskListener var1);

        public boolean isFinished();

        public void setUseDefaultListener(boolean var1);
    }

    public static interface CloudStatusListener {
        public void handleIssueDataDownloadedEvent();

        public void handleStateChange(SigninState var1, SigninState var2);
    }

    public static interface CloudListener {
        public void issueUpdated(BugInstance var1);

        public void statusUpdated();

        public void taskStarted(CloudTask var1);
    }
}

