/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class WronglyOrderedWays
extends Test {
    Map<Point2D, List<Way>> _cellWays;
    Bag<Way, Way> _errorWays;

    public WronglyOrderedWays() {
        super(I18n.tr((String)"Wrongly Ordered Ways."), I18n.tr((String)"This test checks the direction of water, land and coastline ways."));
    }

    public void startTest() {
        this._cellWays = new HashMap<Point2D, List<Way>>(1000);
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._cellWays = null;
        this._errorWays = null;
    }

    public void visit(Way w) {
        String errortype = "";
        if (w.deleted || w.incomplete) {
            return;
        }
        String natural = w.get("natural");
        if (natural == null) {
            return;
        }
        if (!natural.equals("coastline")) {
            errortype = "Clockwise coastline";
        } else if (!natural.equals("water")) {
            errortype = "Clockwise water";
        } else if (!natural.equals("land")) {
            errortype = "Clockwise land";
        } else {
            return;
        }
        if (w.nodes.get(0) == w.nodes.get(w.nodes.size() - 1)) {
            int prevnode;
            int nextnode;
            int maxnode = -1;
            double maxlat = -90.0;
            for (int node = 0; node < w.nodes.size(); ++node) {
                double lat = ((Node)w.nodes.get((int)node)).coor.lat();
                if (!(lat > maxlat)) continue;
                maxnode = node;
                maxlat = lat;
            }
            if (maxnode == 0) {
                nextnode = 1;
                prevnode = w.nodes.size() - 1;
            } else if (maxnode == w.nodes.size() - 1) {
                nextnode = 0;
                prevnode = maxnode - 1;
            } else {
                nextnode = maxnode + 1;
                prevnode = maxnode - 1;
            }
            double prevlon = ((Node)w.nodes.get((int)prevnode)).coor.lon();
            double nextlon = ((Node)w.nodes.get((int)nextnode)).coor.lon();
            if ((natural.equals("coastline") || natural.equals("land")) && prevlon < nextlon || natural.equals("water") && prevlon > nextlon) {
                ArrayList<Way> primitives = new ArrayList<Way>();
                primitives.add(w);
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)errortype), primitives));
                this._errorWays.add(w, w);
            }
        }
    }
}

