/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class InterfaceDeleter
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final boolean[] delete;

    public InterfaceDeleter(boolean[] blArray) {
        this.delete = blArray;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        int[] nArray = programClass.u2interfaces;
        int n = programClass.u2interfacesCount;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.delete[i]) continue;
            nArray[n2++] = nArray[i];
        }
        if (n2 < n) {
            programClass.u2interfacesCount = n2;
            programClass.attributesAccept(this);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        Object[] objectArray = signatureAttribute.referencedClasses;
        if (objectArray != null) {
            int n;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signatureAttribute.getSignature(clazz));
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            int n3 = 0;
            while (internalTypeEnumeration.hasMoreTypes()) {
                String string = internalTypeEnumeration.nextType();
                stringBuffer.append(string);
                int n4 = new DescriptorClassEnumeration(string).classCount();
                for (n = 0; n < n4; ++n) {
                    objectArray[n3++] = objectArray[n2++];
                }
                if (!ClassUtil.isInternalClassType(string)) continue;
                break;
            }
            int n5 = 0;
            while (internalTypeEnumeration.hasMoreTypes()) {
                String string = internalTypeEnumeration.nextType();
                n = new DescriptorClassEnumeration(string).classCount();
                if (!this.delete[n5++]) {
                    stringBuffer.append(string);
                    for (int i = 0; i < n; ++i) {
                        objectArray[n3++] = objectArray[n2++];
                    }
                    continue;
                }
                n2 += n;
            }
            ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(stringBuffer.toString());
            Arrays.fill(objectArray, n3, n2, null);
        }
    }
}

