/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MemberObfuscator;
import proguard.util.ListUtil;

public class MappingKeeper
implements MappingProcessor {
    private final ClassPool classPool;
    private final WarningPrinter warningPrinter;
    private Clazz clazz;

    public MappingKeeper(ClassPool classPool, WarningPrinter warningPrinter) {
        this.classPool = classPool;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public boolean processClassMapping(String string, String string2) {
        String string3 = ClassUtil.internalClassName(string);
        this.clazz = this.classPool.getClass(string3);
        if (this.clazz != null) {
            String string4;
            String string5 = ClassUtil.internalClassName(string2);
            if (this.warningPrinter != null && (string4 = ClassObfuscator.newClassName(this.clazz)) != null && !string4.equals(string5)) {
                this.warningPrinter.print(string3, string4, "Warning: " + string + " is not being kept as '" + ClassUtil.externalClassName(string4) + "', but remapped to '" + string2 + "'");
            }
            ClassObfuscator.setNewClassName(this.clazz, string5);
            return true;
        }
        return false;
    }

    @Override
    public void processFieldMapping(String string, String string2, String string3, String string4) {
        String string5;
        String string6;
        Field field;
        if (this.clazz != null && (field = this.clazz.findField(string6 = string3, string5 = ClassUtil.internalType(string2))) != null) {
            String string7;
            if (this.warningPrinter != null && (string7 = MemberObfuscator.newMemberName(field)) != null && !string7.equals(string4)) {
                this.warningPrinter.print(ClassUtil.internalClassName(string), "Warning: " + string + ": field '" + string2 + " " + string3 + "' is not being kept as '" + string7 + "', but remapped to '" + string4 + "'");
            }
            MemberObfuscator.setFixedNewMemberName(field, string4);
        }
    }

    @Override
    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4, String string5) {
        String string6;
        Method method;
        if (this.clazz != null && (method = this.clazz.findMethod(string3, string6 = ClassUtil.internalMethodDescriptor(string2, ListUtil.commaSeparatedList(string4)))) != null) {
            String string7;
            if (this.warningPrinter != null && (string7 = MemberObfuscator.newMemberName(method)) != null && !string7.equals(string5)) {
                this.warningPrinter.print(ClassUtil.internalClassName(string), "Warning: " + string + ": method '" + string2 + " " + string3 + '(' + string4 + ')' + "' is not being kept as '" + string7 + "', but remapped to '" + string5 + "'");
            }
            MemberObfuscator.setFixedNewMemberName(method, string5);
        }
    }
}

