/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedDoubleValue;
import proguard.evaluation.value.IdentifiedFloatValue;
import proguard.evaluation.value.IdentifiedIntegerValue;
import proguard.evaluation.value.IdentifiedLongValue;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;

public class IdentifiedValueFactory
extends ParticularValueFactory {
    protected int integerID;
    protected int longID;
    protected int floatID;
    protected int doubleID;
    protected int referenceID;

    public IntegerValue createIntegerValue() {
        return new IdentifiedIntegerValue(this, this.integerID++);
    }

    public LongValue createLongValue() {
        return new IdentifiedLongValue(this, this.longID++);
    }

    public FloatValue createFloatValue() {
        return new IdentifiedFloatValue(this, this.floatID++);
    }

    public DoubleValue createDoubleValue() {
        return new IdentifiedDoubleValue(this, this.doubleID++);
    }

    public ReferenceValue createReferenceValue(String string, Clazz clazz, boolean bl) {
        ReferenceValue referenceValue;
        if (string == null) {
            referenceValue = REFERENCE_VALUE_NULL;
        } else {
            int n = this.referenceID++;
            referenceValue = new IdentifiedReferenceValue(string, clazz, bl, this, n);
        }
        return referenceValue;
    }

    public ReferenceValue createArrayReferenceValue(String string, Clazz clazz, IntegerValue integerValue) {
        ReferenceValue referenceValue;
        if (string == null) {
            referenceValue = REFERENCE_VALUE_NULL;
        } else {
            int n = this.referenceID++;
            referenceValue = new IdentifiedArrayReferenceValue('[' + string, clazz, integerValue, this, n);
        }
        return referenceValue;
    }
}

