/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ArrayUtil;

public class CodeAttributeComposer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAXIMUM_LEVELS = 32;
    private static final int INVALID = -1;
    private final boolean allowExternalBranchTargets;
    private final boolean allowExternalExceptionHandlers;
    private final boolean shrinkInstructions;
    private int maximumCodeLength;
    private int codeLength;
    private int exceptionTableLength;
    private int level = -1;
    private byte[] code = new byte[1024];
    private int[] oldInstructionOffsets = new int[1024];
    private final int[] codeFragmentOffsets = new int[32];
    private final int[] codeFragmentLengths = new int[32];
    private final int[][] instructionOffsetMap = new int[32][1025];
    private ExceptionInfo[] exceptionTable = new ExceptionInfo[16];
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();

    public CodeAttributeComposer() {
        this(false, false, true);
    }

    public CodeAttributeComposer(boolean bl, boolean bl2, boolean bl3) {
        this.allowExternalBranchTargets = bl;
        this.allowExternalExceptionHandlers = bl2;
        this.shrinkInstructions = bl3;
    }

    public void reset() {
        this.maximumCodeLength = 0;
        this.codeLength = 0;
        this.exceptionTableLength = 0;
        this.level = -1;
        this.instructionWriter.reset(this.code.length);
    }

    public void beginCodeFragment(int n) {
        ++this.level;
        if (this.level >= 32) {
            throw new IllegalArgumentException("Maximum number of code fragment levels exceeded [" + this.level + "]");
        }
        this.maximumCodeLength += n;
        this.ensureCodeLength(this.maximumCodeLength);
        if (this.instructionOffsetMap[this.level].length <= n) {
            this.instructionOffsetMap[this.level] = new int[n + 1];
        }
        for (int i = 0; i <= n; ++i) {
            this.instructionOffsetMap[this.level][i] = -1;
        }
        this.codeFragmentOffsets[this.level] = this.codeLength;
        this.codeFragmentLengths[this.level] = n;
    }

    public void appendInstruction(int n, Instruction instruction) {
        if (this.shrinkInstructions) {
            instruction = instruction.shrink();
        }
        int n2 = this.codeLength + instruction.length(this.codeLength);
        this.ensureCodeLength(n2);
        this.oldInstructionOffsets[this.codeLength] = n;
        this.instructionOffsetMap[this.level][n] = this.codeLength;
        instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), this.codeLength, this.instructionWriter);
        this.codeLength = n2;
    }

    public void appendLabel(int n) {
        this.ensureCodeLength(this.codeLength + 1);
        this.oldInstructionOffsets[this.codeLength] = n;
        this.instructionOffsetMap[this.level][n] = this.codeLength;
    }

    public void appendInstructions(Instruction[] instructionArray) {
        for (int i = 0; i < instructionArray.length; ++i) {
            this.appendInstruction(instructionArray[i]);
        }
    }

    public void appendInstruction(Instruction instruction) {
        if (this.shrinkInstructions) {
            instruction = instruction.shrink();
        }
        int n = this.codeLength + instruction.length(this.codeLength);
        this.ensureCodeLength(n);
        instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), this.codeLength, this.instructionWriter);
        this.codeLength = n;
    }

    public void appendException(ExceptionInfo exceptionInfo) {
        this.visitExceptionInfo(null, null, null, exceptionInfo);
        if (exceptionInfo.u2startPC == exceptionInfo.u2endPC) {
            return;
        }
        this.exceptionTable = (ExceptionInfo[])ArrayUtil.add(this.exceptionTable, this.exceptionTableLength++, exceptionInfo);
    }

    public void endCodeFragment() {
        Instruction instruction;
        if (this.level < 0) {
            throw new IllegalArgumentException("Code fragment not begun [" + this.level + "]");
        }
        for (int i = this.codeFragmentOffsets[this.level]; i < this.codeLength; i += instruction.length(i)) {
            instruction = InstructionFactory.create(this.code, i);
            if (this.oldInstructionOffsets[i] < 0) continue;
            instruction.accept(null, null, null, i, this);
            instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), i, this.instructionWriter);
        }
        this.maximumCodeLength += this.codeLength - this.codeFragmentOffsets[this.level] - this.codeFragmentLengths[this.level];
        if (this.allowExternalExceptionHandlers) {
            for (int i = 0; i < this.exceptionTableLength; ++i) {
                ExceptionInfo exceptionInfo = this.exceptionTable[i];
                int n = -exceptionInfo.u2handlerPC;
                if (n <= 0) continue;
                if (this.remappableExceptionHandler(n)) {
                    exceptionInfo.u2handlerPC = this.newInstructionOffset(n);
                    continue;
                }
                if (this.level != 0) continue;
                throw new IllegalStateException("Couldn't remap exception handler offset [" + n + "]");
            }
        }
        --this.level;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.level != -1) {
            throw new IllegalArgumentException("Code fragment not ended [" + this.level + "]");
        }
        ++this.level;
        if (codeAttribute.u4codeLength < this.codeLength) {
            codeAttribute.code = new byte[this.codeLength];
        }
        codeAttribute.u4codeLength = this.codeLength;
        System.arraycopy(this.code, 0, codeAttribute.code, 0, this.codeLength);
        if (codeAttribute.exceptionTable.length < this.exceptionTableLength) {
            codeAttribute.exceptionTable = new ExceptionInfo[this.exceptionTableLength];
        }
        codeAttribute.u2exceptionTableLength = this.exceptionTableLength;
        System.arraycopy(this.exceptionTable, 0, codeAttribute.exceptionTable, 0, this.exceptionTableLength);
        this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
        this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        --this.level;
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        lineNumberTableAttribute.u2lineNumberTableLength = this.removeEmptyLineNumbers(lineNumberTableAttribute.lineNumberTable, lineNumberTableAttribute.u2lineNumberTableLength, codeAttribute.u4codeLength);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        block2: {
            try {
                branchInstruction.branchOffset = this.newBranchOffset(n, branchInstruction.branchOffset);
                this.oldInstructionOffsets[n] = -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.level != 0 && this.allowExternalBranchTargets) break block2;
                throw illegalArgumentException;
            }
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        block2: {
            try {
                switchInstruction.defaultOffset = this.newBranchOffset(n, switchInstruction.defaultOffset);
                this.updateJumpOffsets(n, switchInstruction.jumpOffsets);
                this.oldInstructionOffsets[n] = -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.level != 0 && this.allowExternalBranchTargets) break block2;
                throw illegalArgumentException;
            }
        }
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.newInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.newInstructionOffset(exceptionInfo.u2endPC);
        int n = exceptionInfo.u2handlerPC;
        exceptionInfo.u2handlerPC = !this.allowExternalExceptionHandlers || this.remappableExceptionHandler(n) ? this.newInstructionOffset(n) : -n;
    }

    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
        int n2;
        int n3 = n2 = this.newInstructionOffset(n);
        if (this.expectedStackMapFrameOffset >= 0) {
            n3 -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = n2 + 1;
        }
        stackMapFrame.u2offsetDelta = n3;
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.newInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.newInstructionOffset(lineNumberInfo.u2startPC);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        int n = this.newInstructionOffset(localVariableInfo.u2startPC);
        int n2 = this.newInstructionOffset(localVariableInfo.u2startPC + localVariableInfo.u2length);
        localVariableInfo.u2startPC = n;
        localVariableInfo.u2length = n2 - n;
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        int n = this.newInstructionOffset(localVariableTypeInfo.u2startPC);
        int n2 = this.newInstructionOffset(localVariableTypeInfo.u2startPC + localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = n;
        localVariableTypeInfo.u2length = n2 - n;
    }

    private void ensureCodeLength(int n) {
        if (this.code.length < n) {
            n = n * 6 / 5;
            this.code = ArrayUtil.extendArray(this.code, n);
            this.oldInstructionOffsets = ArrayUtil.extendArray(this.oldInstructionOffsets, n);
            this.instructionWriter.extend(n);
        }
    }

    private void updateJumpOffsets(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.newBranchOffset(n, nArray[i]);
        }
    }

    private int newBranchOffset(int n, int n2) {
        if (n < 0 || n > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        int n3 = this.oldInstructionOffsets[n];
        return this.newInstructionOffset(n3 + n2) - n;
    }

    private int newInstructionOffset(int n) {
        if (n < 0 || n > this.codeFragmentLengths[this.level]) {
            throw new IllegalArgumentException("Instruction offset [" + n + "] out of range in code fragment with length [" + this.codeFragmentLengths[this.level] + "] at level " + this.level);
        }
        int n2 = this.instructionOffsetMap[this.level][n];
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code fragment at level " + this.level);
        }
        return n2;
    }

    private boolean remappableExceptionHandler(int n) {
        if (n > this.codeFragmentLengths[this.level]) {
            return false;
        }
        int n2 = this.instructionOffsetMap[this.level][n];
        return n2 > -1 && n2 < this.codeLength;
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ExceptionInfo exceptionInfo = exceptionInfoArray[i];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfoArray[n2++] = exceptionInfo;
        }
        Arrays.fill(exceptionInfoArray, n2, n, null);
        return n2;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LineNumberInfo lineNumberInfo = lineNumberInfoArray[i];
            int n4 = lineNumberInfo.u2startPC;
            if (n4 >= n2 || i != 0 && n4 <= lineNumberInfoArray[i - 1].u2startPC) continue;
            lineNumberInfoArray[n3++] = lineNumberInfo;
        }
        Arrays.fill(lineNumberInfoArray, n3, n, null);
        return n3;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[i];
            if (localVariableInfo.u2length <= 0 || localVariableInfo.u2index >= n2) continue;
            localVariableInfoArray[n3++] = localVariableInfo;
        }
        Arrays.fill(localVariableInfoArray, n3, n, null);
        return n3;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[i];
            if (localVariableTypeInfo.u2length <= 0 || localVariableTypeInfo.u2index >= n2) continue;
            localVariableTypeInfoArray[n3++] = localVariableTypeInfo;
        }
        Arrays.fill(localVariableTypeInfoArray, n3, n, null);
        return n3;
    }

    private void println(String string, String string2) {
        this.print(string, string2);
        System.out.println();
    }

    private void print(String string, String string2) {
        System.out.print(string);
        for (int i = 0; i < this.level; ++i) {
            System.out.print("  ");
        }
        System.out.print(string2);
    }

    public static void main(String[] stringArray) {
        CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
        codeAttributeComposer.beginCodeFragment(4);
        codeAttributeComposer.appendInstruction(0, new SimpleInstruction(3));
        codeAttributeComposer.appendInstruction(1, new VariableInstruction(54, 0));
        codeAttributeComposer.appendInstruction(2, new BranchInstruction(-89, 1));
        codeAttributeComposer.beginCodeFragment(4);
        codeAttributeComposer.appendInstruction(0, new VariableInstruction(-124, 0, 1));
        codeAttributeComposer.appendInstruction(1, new VariableInstruction(21, 0));
        codeAttributeComposer.appendInstruction(2, new SimpleInstruction(8));
        codeAttributeComposer.appendInstruction(3, new BranchInstruction(-95, -3));
        codeAttributeComposer.endCodeFragment();
        codeAttributeComposer.appendInstruction(3, new SimpleInstruction(-79));
        codeAttributeComposer.endCodeFragment();
    }
}

