/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintStream;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class MappingPrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final PrintStream ps;

    public MappingPrinter() {
        this(System.out);
    }

    public MappingPrinter(PrintStream printStream) {
        this.ps = printStream;
    }

    public void visitProgramClass(ProgramClass programClass) {
        String string = programClass.getName();
        String string2 = ClassObfuscator.newClassName(programClass);
        this.ps.println(ClassUtil.externalClassName(string) + " -> " + ClassUtil.externalClassName(string2) + ":");
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string = MemberObfuscator.newMemberName(programField);
        if (string != null) {
            this.ps.println("    " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + " -> " + string);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        if (ClassUtil.isInitializer(string)) {
            return;
        }
        String string2 = MemberObfuscator.newMemberName(programMethod);
        if (string2 != null) {
            this.ps.print("    ");
            programMethod.attributesAccept(programClass, this);
            this.ps.println(ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + " -> " + string2);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.ps.print(lineNumberTableAttribute.getLowestLineNumber() + ":" + lineNumberTableAttribute.getHighestLineNumber() + ":");
    }
}

