/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class RelationalOp {
    final String value;
    final String name;
    @StaticConstant
    private static final Map<String, RelationalOp> map = new HashMap<String, RelationalOp>();
    public static final RelationalOp EQ = new RelationalOp("==", "EQ"){

        @Override
        public <T extends Comparable<T>> boolean check(T x, T y) {
            return x.compareTo(y) == 0;
        }
    };
    public static final RelationalOp LEQ = new RelationalOp("<=", "LEQ"){

        @Override
        public <T extends Comparable<T>> boolean check(T x, T y) {
            return x.compareTo(y) <= 0;
        }
    };
    public static final RelationalOp NEQ = new RelationalOp("!=", "NEQ"){

        @Override
        public <T extends Comparable<T>> boolean check(T x, T y) {
            return x.compareTo(y) != 0;
        }
    };
    public static final RelationalOp GEQ = new RelationalOp(">=", "GEQ"){

        @Override
        public <T extends Comparable<T>> boolean check(T x, T y) {
            return x.compareTo(y) >= 0;
        }
    };
    public static final RelationalOp LT = new RelationalOp("<", "LT"){

        @Override
        public <T extends Comparable<T>> boolean check(T x, T y) {
            return x.compareTo(y) < 0;
        }
    };
    public static final RelationalOp GT = new RelationalOp(">", "GT"){

        @Override
        public <T extends Comparable<T>> boolean check(T x, T y) {
            return x.compareTo(y) > 0;
        }
    };

    public abstract <T extends Comparable<T>> boolean check(T var1, T var2);

    public static RelationalOp byName(String s) {
        RelationalOp relationalOp = map.get(s);
        if (relationalOp == null) {
            throw new IllegalArgumentException("Could not find relOp named " + s + " in " + map.keySet());
        }
        return relationalOp;
    }

    public static Collection<RelationalOp> values() {
        return map.values();
    }

    @Deprecated
    private RelationalOp(String value) {
        this(value, "xxx");
    }

    private RelationalOp(String value, String name) {
        this.value = value;
        this.name = name;
        map.put(name, this);
    }

    public String toString() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

