/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jacoco.report.internal.xml.XMLElement;

public class XMLDocument
extends XMLElement {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"%s\"?>";
    private static final String HEADER_STANDALONE = "<?xml version=\"1.0\" encoding=\"%s\" standalone=\"yes\"?>";
    private static final String DOCTYPE = "<!DOCTYPE %s PUBLIC \"%s\" \"%s\">";

    public XMLDocument(String rootnode, String pubId, String system, String encoding, boolean standalone, Writer writer) throws IOException {
        super(writer, rootnode);
        XMLDocument.writeHeader(rootnode, pubId, system, encoding, standalone, writer);
        this.beginOpenTag();
    }

    public XMLDocument(String rootnode, String pubId, String system, String encoding, boolean standalone, OutputStream output) throws IOException {
        this(rootnode, pubId, system, encoding, standalone, new OutputStreamWriter(output, encoding));
    }

    public void close() throws IOException {
        super.close();
        this.writer.close();
    }

    private static void writeHeader(String rootnode, String pubId, String system, String encoding, boolean standalone, Writer writer) throws IOException {
        if (standalone) {
            writer.write(String.format(HEADER_STANDALONE, encoding));
        } else {
            writer.write(String.format(HEADER, encoding));
        }
        if (pubId != null) {
            writer.write(String.format(DOCTYPE, rootnode, pubId, system));
        }
    }
}

