/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.io.IOException;
import java.util.Date;
import org.dom4j.DocumentException;

public class BackdateHistoryUsingSource {
    private static final String USAGE = "Usage: <cmd>   <bugs.xml> [<out.xml>]";

    public static void main(String[] args) throws IOException, DocumentException {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        if (args.length < 1 || args.length > 2) {
            System.out.println(USAGE);
            return;
        }
        SortedBugCollection origCollection = new SortedBugCollection();
        origCollection.readXML(args[0]);
        SourceFinder sourceFinder = new SourceFinder(origCollection.getProject());
        for (BugInstance b : origCollection) {
            SourceFile sourceFile;
            long when;
            SourceLineAnnotation s = b.getPrimarySourceLineAnnotation();
            if (!s.isSourceFileKnown() || !sourceFinder.hasSourceFile(s) || (when = (sourceFile = sourceFinder.findSourceFile(s)).getLastModified()) <= 0L) continue;
            Date firstSeen = new Date(when);
            b.getXmlProps().setFirstSeen(firstSeen);
            System.out.println("Set first seen to " + firstSeen);
        }
        Cloud cloud = origCollection.getCloud();
        cloud.bugsPopulated();
        if (cloud.getSigninState() != Cloud.SigninState.SIGNED_IN && cloud.getSigninState() != Cloud.SigninState.NO_SIGNIN_REQUIRED) {
            cloud.signIn();
            if (cloud.getSigninState() != Cloud.SigninState.SIGNED_IN && cloud.getSigninState() != Cloud.SigninState.NO_SIGNIN_REQUIRED) {
                throw new IllegalStateException("Unable to sign in; state : " + (Object)((Object)cloud.getSigninState()));
            }
        }
        cloud.waitUntilIssueDataDownloaded();
        if (args.length > 1) {
            origCollection.writeXML(args[1]);
        }
        cloud.waitUntilNewIssuesUploaded();
        cloud.shutdown();
    }
}

