/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import edu.umd.cs.findbugs.sourceViewer.HighlightInformation;
import edu.umd.cs.findbugs.sourceViewer.NoWrapBoxView;
import edu.umd.cs.findbugs.sourceViewer.NumberedParagraphView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class NumberedViewFactory
implements ViewFactory {
    final HighlightInformation highlight;

    public NumberedViewFactory(HighlightInformation highlight) {
        this.highlight = highlight;
    }

    @Override
    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new LabelView(elem);
            }
            if (kind.equals("paragraph")) {
                return new NumberedParagraphView(elem, this.highlight);
            }
            if (kind.equals("section")) {
                return new NoWrapBoxView(elem, 1);
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new LabelView(elem);
    }
}

