/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SignatureUtil {
    public static String createMethodSignature(String params, String returns) {
        String pString;
        if (params == null && returns == null) {
            return null;
        }
        if (params == null) {
            pString = ".*";
        } else {
            StringBuilder buf = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(params, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                String param = SignatureUtil.typeToSignature(tok.nextToken());
                buf.append(param);
            }
            pString = buf.toString();
        }
        String rString = returns == null ? ".*" : SignatureUtil.typeToSignature(returns);
        if (params == null || returns == null) {
            String result = "~\\(" + pString + "\\)" + rString;
            assert (Pattern.compile(result.substring(1)) != null);
            return result;
        }
        return "(" + pString + ")" + rString;
    }

    public static String createFieldSignature(String type) {
        if (type == null) {
            return null;
        }
        return SignatureUtil.typeToSignature(type);
    }

    private static String typeToSignature(String type) {
        if (type.endsWith("[]")) {
            return "[" + SignatureUtil.typeToSignature(type.substring(0, type.length() - 2));
        }
        return SignatureUtil.scalarTypeToSiganture(type);
    }

    private static String scalarTypeToSiganture(String type) {
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("void")) {
            return "V";
        }
        return "L" + type.replace('.', '/') + ";";
    }
}

