/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.EditDistance;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class UncallableMethodOfAnonymousClass
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    XMethod potentialSuperCall;
    BugInstance pendingBug;

    public UncallableMethodOfAnonymousClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitJavaClass(JavaClass obj) {
        boolean isAnonymousInnerClass;
        try {
            obj.getSuperClass();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return;
        }
        String superclassName2 = this.getSuperclassName();
        boolean weird = superclassName2.equals("java.lang.Object") && obj.getInterfaceIndices().length == 0;
        boolean hasAnonymousName = ClassName.isAnonymous(obj.getClassName());
        boolean bl = isAnonymousInnerClass = hasAnonymousName && !weird;
        if (isAnonymousInnerClass) {
            super.visitJavaClass(obj);
        }
    }

    boolean definedInThisClassOrSuper(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        for (Method m : clazz.getMethods()) {
            String key = m.getName() + ":" + m.getSignature();
            if (m.isStatic() || !method.equals(key)) continue;
            return true;
        }
        return this.definedInSuperClassOrInterface(clazz, method);
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 183) {
            XMethod m = this.getXMethodOperand();
            if (m == null) {
                return;
            }
            XClass c = this.getXClass();
            int nameDistance = EditDistance.editDistance(m.getName(), this.getMethodName());
            if (nameDistance < 4 && c.findMatchingMethod(m.getMethodDescriptor()) == null && !m.isFinal()) {
                this.potentialSuperCall = m;
            }
        }
    }

    boolean definedInSuperClassOrInterface(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        JavaClass superClass = clazz.getSuperClass();
        if (superClass == null) {
            return false;
        }
        try {
            XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptorFromDottedClassName(superClass.getClassName()));
            if (xClass.hasStubs()) {
                return true;
            }
        }
        catch (CheckedAnalysisException e) {
            return true;
        }
        if (this.definedInThisClassOrSuper(superClass, method)) {
            return true;
        }
        for (JavaClass i : clazz.getInterfaces()) {
            if (!this.definedInThisClassOrSuper(i, method)) continue;
            return true;
        }
        return false;
    }

    Set<String> definedInClass(JavaClass clazz) {
        HashSet<String> result = new HashSet<String>();
        for (Method m : clazz.getMethods()) {
            if (this.skip(m)) continue;
            result.add(m.getName() + m.getSignature());
        }
        return result;
    }

    private boolean skip(Method obj) {
        if (BCELUtil.isSynthetic(obj)) {
            return true;
        }
        if (obj.isPrivate()) {
            return true;
        }
        if (obj.isAbstract()) {
            return true;
        }
        String methodName = obj.getName();
        String sig = obj.getSignature();
        if (methodName.equals("<init>")) {
            return true;
        }
        if (methodName.equals("<clinit>")) {
            return true;
        }
        if (sig.equals("()Ljava/lang/Object;") && (methodName.equals("readResolve") || methodName.equals("writeReplace"))) {
            return true;
        }
        if (methodName.startsWith("access$")) {
            return true;
        }
        if (methodName.length() < 2 || methodName.indexOf(36) >= 0) {
            return true;
        }
        XMethod m = this.getXMethod();
        for (ClassDescriptor c : m.getAnnotationDescriptors()) {
            if (c.getClassName().indexOf("inject") < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doVisitMethod(Method obj) {
        super.doVisitMethod(obj);
        if (this.pendingBug != null) {
            if (this.potentialSuperCall == null) {
                String role = "CLASS_SUPERCLASS";
                String superclassName = ClassName.toDottedClassName(this.getSuperclassName());
                if (superclassName.equals("java.lang.Object")) {
                    try {
                        JavaClass[] interfaces = this.getThisClass().getInterfaces();
                        if (interfaces.length == 1) {
                            superclassName = interfaces[0].getClassName();
                            role = "CLASS_IMPLEMENTED_INTERFACE";
                        }
                    }
                    catch (ClassNotFoundException e) {
                        AnalysisContext.reportMissingClass(e);
                    }
                }
                this.pendingBug.addClass(superclassName).describe(role);
                try {
                    XClass from = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptorFromDottedClassName(superclassName));
                    XMethod potentialMatch = null;
                    for (XMethod xMethod : from.getXMethods()) {
                        if (xMethod.isStatic() || xMethod.isPrivate() || !xMethod.getName().toLowerCase().equals(obj.getName().toLowerCase())) continue;
                        if (potentialMatch == null) {
                            potentialMatch = xMethod;
                            continue;
                        }
                        potentialMatch = null;
                        break;
                    }
                    if (potentialMatch != null) {
                        this.pendingBug.addMethod(potentialMatch).describe("METHOD_DID_YOU_MEAN_TO_OVERRIDE");
                    }
                }
                catch (CheckedAnalysisException e) {
                    AnalysisContext.logError("Error: ", e);
                }
            } else {
                this.pendingBug.setPriority(this.pendingBug.getPriority() - 1);
                this.pendingBug.addMethod(this.potentialSuperCall).describe("METHOD_DID_YOU_MEAN_TO_OVERRIDE");
            }
            this.bugReporter.reportBug(this.pendingBug);
            this.pendingBug = null;
            this.potentialSuperCall = null;
        }
    }

    @Override
    public void visit(Code obj) {
        if (this.pendingBug != null) {
            super.visit(obj);
        }
    }

    @Override
    public void visit(Method obj) {
        try {
            if (this.skip(obj)) {
                return;
            }
            JavaClass clazz = this.getThisClass();
            XMethod xmethod = XFactory.createXMethod(clazz, obj);
            XFactory factory = AnalysisContext.currentXFactory();
            String key = obj.getName() + ":" + obj.getSignature();
            if (!(factory.isCalled(xmethod) || !obj.isStatic() && this.definedInSuperClassOrInterface(clazz, key))) {
                int priority = 2;
                JavaClass superClass = clazz.getSuperClass();
                String superClassName = superClass.getClassName();
                priority = superClassName.equals("java.lang.Object") ? 2 : (this.definedInClass(superClass).containsAll(this.definedInClass(clazz)) ? 2 : 1);
                Attribute code = null;
                for (Attribute a : obj.getAttributes()) {
                    if (!(a instanceof Code)) continue;
                    code = (Code)a;
                    break;
                }
                if (code != null && code.getLength() == 1) {
                    ++priority;
                }
                this.pendingBug = new BugInstance(this, "UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS", priority).addClassAndMethod(this);
                this.potentialSuperCall = null;
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
    }
}

