/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.InstructionHandle;

public class RuntimeExceptionCapture
extends OpcodeStackDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("rec.debug");
    private final BugReporter bugReporter;
    private final List<ExceptionCaught> catchList = new ArrayList<ExceptionCaught>();
    private final List<ExceptionThrown> throwList = new ArrayList<ExceptionThrown>();
    private final BugAccumulator accumulator;

    public RuntimeExceptionCapture(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitJavaClass(JavaClass c) {
        super.visitJavaClass(c);
        this.accumulator.reportAccumulatedBugs();
    }

    @Override
    public void visitAfter(Code obj) {
        for (ExceptionCaught caughtException : this.catchList) {
            HashSet<String> thrownSet = new HashSet<String>();
            for (ExceptionThrown thrownException : this.throwList) {
                if (thrownException.offset < caughtException.startOffset || thrownException.offset >= caughtException.endOffset) continue;
                thrownSet.add(thrownException.exceptionClass);
                if (!thrownException.exceptionClass.equals(caughtException.exceptionClass)) continue;
                caughtException.seen = true;
            }
            int catchClauses = 0;
            if (!caughtException.exceptionClass.equals("java.lang.Exception") || caughtException.seen) continue;
            boolean rteCaught = false;
            for (ExceptionCaught otherException : this.catchList) {
                if (otherException.startOffset != caughtException.startOffset || otherException.endOffset != caughtException.endOffset) continue;
                ++catchClauses;
                if (!otherException.exceptionClass.equals("java.lang.RuntimeException")) continue;
                rteCaught = true;
            }
            int range = caughtException.endOffset - caughtException.startOffset;
            if (rteCaught) continue;
            int priority = 4;
            if (range > 300) {
                --priority;
            } else if (range < 30) {
                ++priority;
            }
            if (catchClauses > 1) {
                ++priority;
            }
            if (thrownSet.size() > 1) {
                --priority;
            }
            if (caughtException.dead) {
                --priority;
            }
            this.accumulator.accumulateBug(new BugInstance(this, "REC_CATCH_EXCEPTION", priority).addClassAndMethod(this), SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, caughtException.sourcePC));
        }
        this.catchList.clear();
        this.throwList.clear();
    }

    @Override
    public void visit(CodeException obj) {
        try {
            super.visit(obj);
            int type = obj.getCatchType();
            if (type == 0) {
                return;
            }
            String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
            ExceptionCaught caughtException = new ExceptionCaught(name, obj.getStartPC(), obj.getEndPC(), obj.getHandlerPC());
            this.catchList.add(caughtException);
            LiveLocalStoreDataflow dataflow = this.getClassContext().getLiveLocalStoreDataflow(this.getMethod());
            CFG cfg = this.getClassContext().getCFG(this.getMethod());
            Collection<BasicBlock> blockList = cfg.getBlocksContainingInstructionWithOffset(obj.getHandlerPC());
            for (BasicBlock block : blockList) {
                InstructionHandle first = block.getFirstInstruction();
                if (first == null || first.getPosition() != obj.getHandlerPC() || !(first.getInstruction() instanceof ASTORE)) continue;
                ASTORE astore = (ASTORE)first.getInstruction();
                BitSet liveStoreSet = (BitSet)dataflow.getFactAtLocation(new Location(first, block));
                if (liveStoreSet.get(astore.getIndex())) continue;
                if (DEBUG) {
                    System.out.println("Dead exception store at " + first);
                }
                caughtException.dead = true;
                break;
            }
        }
        catch (MethodUnprofitableException e) {
            Method m = this.getMethod();
            this.bugReporter.reportSkippedAnalysis(DescriptorFactory.instance().getMethodDescriptor(this.getClassName(), this.getMethodName(), this.getMethodSig(), m.isStatic()));
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Error checking for dead exception store", e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Error checking for dead exception store", e);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 191: {
                OpcodeStack.Item item;
                String signature;
                if (this.stack.getStackDepth() <= 0 || (signature = (item = this.stack.getStackItem(0)).getSignature()) == null || signature.length() <= 0) break;
                signature = signature.startsWith("L") ? SignatureConverter.convert(signature) : signature.replace('/', '.');
                this.throwList.add(new ExceptionThrown(signature, this.getPC()));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                String className = this.getClassConstantOperand();
                if (className.startsWith("[")) break;
                try {
                    String[] exceptions;
                    XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptor(className));
                    XMethod m = Hierarchy2.findInvocationLeastUpperBound(c, this.getNameConstantOperand(), this.getSigConstantOperand(), seen == 184, seen == 185);
                    if (m == null || (exceptions = m.getThrownExceptions()) == null) break;
                    for (String name : exceptions) {
                        this.throwList.add(new ExceptionThrown(ClassName.toDottedClassName(name), this.getPC()));
                    }
                    break;
                }
                catch (MissingClassException e) {
                    this.bugReporter.reportMissingClass(e.getClassDescriptor());
                    break;
                }
                catch (CheckedAnalysisException e) {
                    this.bugReporter.logError("Error looking up " + className, e);
                    break;
                }
            }
        }
    }

    private static class ExceptionThrown {
        @DottedClassName
        public String exceptionClass;
        public int offset;

        public ExceptionThrown(@DottedClassName String exceptionClass, int offset) {
            this.exceptionClass = exceptionClass;
            this.offset = offset;
        }
    }

    private static class ExceptionCaught {
        public String exceptionClass;
        public int startOffset;
        public int endOffset;
        public int sourcePC;
        public boolean seen = false;
        public boolean dead = false;

        public ExceptionCaught(String exceptionClass, int startOffset, int endOffset, int sourcePC) {
            this.exceptionClass = exceptionClass;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sourcePC = sourcePC;
        }
    }
}

