/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import org.apache.bcel.classfile.Code;

public class LostLoggerDueToWeakReference
extends OpcodeStackDetector {
    final BugAccumulator bugAccumulator;
    final HashSet<String> namesOfSetterMethods = new HashSet();
    int sawGetLogger;
    boolean loggerEscaped;
    boolean loggerImported;

    public LostLoggerDueToWeakReference(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.namesOfSetterMethods.add("addHandler");
        this.namesOfSetterMethods.add("setUseParentHandlers");
        this.namesOfSetterMethods.add("setLevel");
        this.namesOfSetterMethods.add("setFilter");
    }

    @Override
    public void visit(Code code) {
        if (this.getMethodSig().indexOf("Logger") == -1) {
            this.sawGetLogger = -1;
            this.loggerImported = false;
            this.loggerEscaped = false;
            super.visit(code);
            if (this.sawGetLogger >= 0 && !this.loggerEscaped && !this.loggerImported) {
                this.bugAccumulator.reportAccumulatedBugs();
            } else {
                this.bugAccumulator.clearBugs();
            }
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.loggerEscaped || this.loggerImported) {
            return;
        }
        switch (seen) {
            case 184: {
                if (this.getClassConstantOperand().equals("java/util/logging/Logger") && this.getNameConstantOperand().equals("getLogger")) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if ("".equals(item.getConstant())) break;
                    this.sawGetLogger = this.getPC();
                    break;
                }
                this.checkForImport();
                break;
            }
            case 182: {
                if (this.getClassConstantOperand().equals("java/util/logging/Logger") && this.namesOfSetterMethods.contains(this.getNameConstantOperand())) {
                    int priority = 1;
                    if (this.getMethod().isStatic() && this.getMethodName().equals("main") && this.getMethodSig().equals("([Ljava/lang/String;)V")) {
                        priority = 2;
                    }
                    OpcodeStack.Item item = this.stack.getItemMethodInvokedOn(this);
                    BugInstance bug = new BugInstance(this, "LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE", priority).addClassAndMethod(this).addValueSource(item, this);
                    this.bugAccumulator.accumulateBug(bug, this);
                    break;
                }
                this.checkForImport();
                this.checkForMethodExportImport();
                break;
            }
            case 183: 
            case 185: {
                this.checkForImport();
                this.checkForMethodExportImport();
                break;
            }
            case 192: {
                String sig = this.getClassConstantOperand();
                if (sig.indexOf("Logger") < 0) break;
                this.loggerImported = true;
                break;
            }
            case 178: 
            case 180: {
                this.checkForImport();
                break;
            }
            case 179: 
            case 181: {
                this.checkForFieldEscape();
                break;
            }
        }
    }

    private void checkForImport() {
        if (this.getSigConstantOperand().endsWith("Logger;")) {
            this.loggerImported = true;
        }
    }

    private void checkForMethodExportImport() {
        int numArguments = PreorderVisitor.getNumberArguments(this.getSigConstantOperand());
        for (int i = 0; i < numArguments; ++i) {
            OpcodeStack.Item item = this.stack.getStackItem(i);
            if (!item.getSignature().endsWith("Logger;")) continue;
            this.loggerEscaped = true;
        }
        String sig = this.getSigConstantOperand();
        int pos = sig.indexOf(41);
        int loggerPos = sig.indexOf("Logger");
        if (0 <= loggerPos && loggerPos < pos) {
            this.loggerEscaped = true;
        }
    }

    private void checkForFieldEscape() {
        OpcodeStack.Item item;
        String sig = this.getSigConstantOperand();
        if (sig.indexOf("Logger") >= 0) {
            this.loggerEscaped = true;
        }
        if ((item = this.stack.getStackItem(0)).getSignature().endsWith("Logger;")) {
            this.loggerEscaped = true;
        }
    }
}

