/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.BitSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindUseOfNonSerializableValue
implements Detector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private static final boolean DEBUG = false;

    public FindUseOfNonSerializableValue(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        boolean skip = false;
        ConstantPool constantPool = javaClass.getConstantPool();
        for (Constant c : constantPool.getConstantPool()) {
            if (!(c instanceof ConstantMethodref) && !(c instanceof ConstantInterfaceMethodref)) continue;
            ConstantCP m = (ConstantCP)c;
            String clazz = m.getClass(constantPool);
            ConstantNameAndType nt = (ConstantNameAndType)constantPool.getConstant(m.getNameAndTypeIndex(), (byte)12);
            String name = nt.getName(constantPool);
            if ((!name.equals("setAttribute") || !clazz.equals("javax.servlet.http.HttpSession")) && (!name.equals("writeObject") || !clazz.equals("java.io.ObjectOutput") && !clazz.equals("java.io.ObjectOutputStream"))) continue;
            skip = false;
            break;
        }
        if (skip) {
            return;
        }
        for (Method method : methodList = javaClass.getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    @CheckForNull
    Use getUse(ConstantPoolGen cpg, Instruction ins) {
        if (ins instanceof InvokeInstruction) {
            InvokeInstruction invoke = (InvokeInstruction)ins;
            String mName = invoke.getMethodName(cpg);
            String cName = invoke.getClassName(cpg);
            if (mName.equals("setAttribute") && cName.equals("javax.servlet.http.HttpSession")) {
                return Use.STORE_INTO_HTTP_SESSION;
            }
            if (mName.equals("writeObject") && (cName.equals("java.io.ObjectOutput") || cName.equals("java.io.ObjectOutputStream"))) {
                return Use.PASSED_TO_WRITE_OBJECT;
            }
        }
        return null;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return;
        }
        if (bytecodeSet.get(193) || bytecodeSet.get(192)) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator<Location> i = cfg.locationIterator();
        block6: while (i.hasNext()) {
            ReferenceType refType;
            Type operandType;
            TypeFrame frame;
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            Use use = this.getUse(cpg, ins);
            if (use == null || !(frame = (TypeFrame)typeDataflow.getFactAtLocation(location)).isValid() || (operandType = (Type)frame.getTopValue()).equals(TopType.instance()) || !(operandType instanceof ReferenceType) || (refType = (ReferenceType)operandType).equals(NullType.instance())) continue;
            try {
                String pattern;
                double isSerializable = DeepSubtypeAnalysis.isDeepSerializable(refType);
                if (!(isSerializable < 0.9)) continue;
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
                ReferenceType problem = DeepSubtypeAnalysis.getLeastSerializableTypeComponent(refType);
                switch (use) {
                    case PASSED_TO_WRITE_OBJECT: {
                        pattern = "DMI_NONSERIALIZABLE_OBJECT_WRITTEN";
                        double isRemote = DeepSubtypeAnalysis.isDeepRemote(refType);
                        if (isRemote >= 0.9) continue block6;
                        if (!(isSerializable < isRemote)) break;
                        isSerializable = isRemote;
                        break;
                    }
                    case STORE_INTO_HTTP_SESSION: {
                        pattern = "J2EE_STORE_OF_NON_SERIALIZABLE_OBJECT_INTO_SESSION";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, pattern, isSerializable < 0.15 ? 1 : (isSerializable > 0.5 ? 3 : 2)).addClassAndMethod(methodGen, sourceFile).addType(problem).describe("TYPE_FOUND"), sourceLineAnnotation);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    @Override
    public void report() {
    }

    static enum Use {
        STORE_INTO_HTTP_SESSION,
        PASSED_TO_WRITE_OBJECT,
        STORED_IN_SERIALZIED_FIELD;

    }
}

