/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindNakedNotify
extends BytecodeScanningDetector
implements StatelessDetector {
    int stage = 0;
    private final BugReporter bugReporter;
    boolean synchronizedMethod;
    private int notifyPC;

    public FindNakedNotify(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        int flags = obj.getAccessFlags();
        this.synchronizedMethod = (flags & 0x20) != 0;
    }

    @Override
    public void visit(Code obj) {
        this.stage = this.synchronizedMethod ? 1 : 0;
        super.visit(obj);
        if (this.synchronizedMethod && this.stage == 4) {
            this.bugReporter.reportBug(new BugInstance(this, "NN_NAKED_NOTIFY", 2).addClassAndMethod(this).addSourceLine(this, this.notifyPC));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (this.stage) {
            case 0: {
                if (seen != 194) break;
                this.stage = 1;
                break;
            }
            case 1: {
                this.stage = 2;
                break;
            }
            case 2: {
                if (seen == 182 && (this.getNameConstantOperand().equals("notify") || this.getNameConstantOperand().equals("notifyAll")) && this.getSigConstantOperand().equals("()V")) {
                    this.stage = 3;
                    this.notifyPC = this.getPC();
                    break;
                }
                this.stage = 0;
                break;
            }
            case 3: {
                this.stage = 4;
                break;
            }
            case 4: {
                if (seen == 195) {
                    this.bugReporter.reportBug(new BugInstance(this, "NN_NAKED_NOTIFY", 2).addClassAndMethod(this).addSourceLine(this, this.notifyPC));
                    this.stage = 5;
                    break;
                }
                this.stage = 0;
                break;
            }
            case 5: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

