/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;

public class CheckCalls
implements Detector,
NonReportingDetector {
    private static final String METHOD = SystemProperties.getProperty("checkcalls.method");
    private static final String TARGET_METHOD = SystemProperties.getProperty("checkcalls.targetmethod");
    BugReporter bugReporter;

    public CheckCalls(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null || METHOD != null && !method.getName().equals(METHOD)) continue;
            try {
                System.out.println("Analyzing " + SignatureConverter.convertMethodSignature(classContext.getJavaClass(), method));
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error", e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error", e);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, ClassNotFoundException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof InvokeInstruction) || TARGET_METHOD != null && !((InvokeInstruction)ins).getMethodName(classContext.getConstantPoolGen()).equals(TARGET_METHOD)) continue;
            System.out.println("\n*******************************************************\n");
            System.out.println("Method invocation: " + location.getHandle());
            System.out.println("\tInvoking: " + SignatureConverter.convertMethodSignature((InvokeInstruction)ins, classContext.getConstantPoolGen()));
            JavaClassAndMethod proto = Hierarchy.findInvocationLeastUpperBound((InvokeInstruction)ins, classContext.getConstantPoolGen());
            if (proto == null) {
                System.out.println("\tUnknown prototype method");
            } else {
                System.out.println("\tPrototype method: class=" + proto.getJavaClass().getClassName() + ", method=" + proto.getMethod());
            }
            Set<JavaClassAndMethod> calledMethodSet = Hierarchy.resolveMethodCallTargets((InvokeInstruction)ins, (TypeFrame)classContext.getTypeDataflow(method).getFactAtLocation(location), classContext.getConstantPoolGen());
            System.out.println("\tTarget method set: " + calledMethodSet);
        }
    }

    @Override
    public void report() {
    }
}

