/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MethodFactory
extends AnalysisFactory<Method> {
    public MethodFactory() {
        super("Method factory", Method.class);
    }

    @Override
    public Method analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, descriptor.getClassDescriptor());
        Method[] methodList = jclass.getMethods();
        Method result = null;
        for (Method method : methodList) {
            MethodDescriptor methodDescriptor = DescriptorFactory.instance().getMethodDescriptor(descriptor.getSlashedClassName(), method.getName(), method.getSignature(), method.isStatic());
            analysisCache.eagerlyPutMethodAnalysis(Method.class, methodDescriptor, method);
            if (!methodDescriptor.equals(descriptor)) continue;
            result = method;
        }
        return result;
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerMethodAnalysisEngine(Method.class, this);
    }
}

