/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.WillClose;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class InstructionActionCache {
    private static final boolean DEBUG_LOOKUP = SystemProperties.getBoolean("oa.debug.lookup");
    private final ObligationPolicyDatabase database;
    private final Map<InstructionHandle, Collection<ObligationPolicyDatabaseAction>> actionCache;
    private final XMethod xmethod;
    private final TypeDataflow typeDataflow;
    private final ConstantPoolGen cpg;
    static final ClassDescriptor WILL_CLOSE = DescriptorFactory.createClassDescriptor(WillClose.class);

    public InstructionActionCache(ObligationPolicyDatabase database, XMethod xmethod, ConstantPoolGen cpg, TypeDataflow typeDataflow) {
        this.database = database;
        this.actionCache = new HashMap<InstructionHandle, Collection<ObligationPolicyDatabaseAction>>();
        this.xmethod = xmethod;
        this.cpg = cpg;
        this.typeDataflow = typeDataflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ObligationPolicyDatabaseAction> getActions(BasicBlock block, InstructionHandle handle) {
        Collection<ObligationPolicyDatabaseAction> actionList = this.actionCache.get(handle);
        if (actionList == null) {
            Instruction ins = handle.getInstruction();
            actionList = Collections.emptyList();
            if (ins instanceof InvokeInstruction) {
                InvokeInstruction inv = (InvokeInstruction)ins;
                XMethod invokedMethod = XFactory.createXMethod(inv, this.cpg);
                String signature = invokedMethod.getSignature();
                String methodName = invokedMethod.getName();
                if (DEBUG_LOOKUP) {
                    System.out.println("Looking up actions for call to " + invokedMethod);
                }
                if (invokedMethod.getAnnotationDescriptors().contains(WILL_CLOSE) && methodName.startsWith("close") && signature.endsWith(")V")) {
                    actionList = Collections.singletonList(ObligationPolicyDatabaseAction.CLEAR);
                } else if (signature.indexOf(59) >= -1) {
                    ReferenceType receiverType = inv.getReferenceType(this.cpg);
                    boolean isStatic = inv.getOpcode() == 184;
                    actionList = new LinkedList<ObligationPolicyDatabaseAction>();
                    this.database.getActions(receiverType, methodName, signature, isStatic, actionList);
                    if (actionList.isEmpty()) {
                        try {
                            Frame factAtLocation = null;
                            SignatureParser sigParser = new SignatureParser(signature);
                            Iterator<String> signatureIterator = sigParser.parameterSignatureIterator();
                            int parameters = sigParser.getNumParameters();
                            for (int i = 0; i < parameters; ++i) {
                                Obligation obligation;
                                Type argumentType;
                                String sig = signatureIterator.next();
                                Collection<ClassDescriptor> annotations = invokedMethod.getParameterAnnotationDescriptors(i);
                                if (!annotations.contains(WILL_CLOSE) && !sig.equals("Ljava/io/Closeable;") && !methodName.startsWith("close")) continue;
                                if (factAtLocation == null) {
                                    factAtLocation = (TypeFrame)this.typeDataflow.getFactAtLocation(new Location(handle, block));
                                }
                                if (!((argumentType = (Type)factAtLocation.getArgument(inv, this.cpg, i, sigParser)) instanceof ObjectType) || (obligation = this.database.getFactory().getObligationByType((ObjectType)argumentType)) == null) continue;
                                actionList.add(new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, obligation));
                            }
                        }
                        catch (CheckedAnalysisException e) {
                            AnalysisContext.logError("Error checking " + invokedMethod, e);
                        }
                        catch (ClassNotFoundException e) {
                            AnalysisContext.reportMissingClass(e);
                        }
                    }
                    if (DEBUG_LOOKUP && !actionList.isEmpty()) {
                        System.out.println("  At " + handle + ": " + actionList);
                    }
                }
            } else if (ins instanceof PUTFIELD || ins instanceof PUTSTATIC || ins instanceof ARETURN) {
                Location loc = new Location(handle, block);
                try {
                    ObligationFactory factory;
                    Obligation obligation;
                    Type tosType;
                    TypeFrame typeFrame = (TypeFrame)this.typeDataflow.getFactAtLocation(loc);
                    if (typeFrame.isValid() && (tosType = (Type)typeFrame.getTopValue()) instanceof ObjectType && (obligation = (factory = this.database.getFactory()).getObligationByType((ObjectType)tosType)) != null) {
                        if (obligation.getClassName().equals("java.sql.ResultSet")) {
                            ObjectType sType = ObjectTypeFactory.getInstance(Statement.class);
                            Obligation sObligation = factory.getObligationByType(sType);
                            actionList = Arrays.asList(new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, obligation), new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, sObligation));
                        } else {
                            actionList = Collections.singleton(new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.DEL, obligation));
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
                catch (Exception e) {
                    AnalysisContext.logError("Error in checking obligation analysis for " + this.xmethod, e);
                }
            }
            this.actionCache.put(handle, actionList);
        }
        return actionList;
    }

    public boolean addsObligation(BasicBlock block, InstructionHandle handle, Obligation obligation) {
        return this.hasAction(block, handle, obligation, ObligationPolicyDatabaseActionType.ADD);
    }

    public boolean deletesObligation(BasicBlock block, InstructionHandle handle, Obligation obligation) {
        return this.hasAction(block, handle, obligation, ObligationPolicyDatabaseActionType.DEL);
    }

    private boolean hasAction(BasicBlock block, InstructionHandle handle, Obligation obligation, ObligationPolicyDatabaseActionType actionType) {
        Collection<ObligationPolicyDatabaseAction> actionList = this.getActions(block, handle);
        for (ObligationPolicyDatabaseAction action : actionList) {
            if (action.getActionType() != actionType || !action.getObligation().equals(obligation)) continue;
            return true;
        }
        return false;
    }
}

